/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.configuration.agent;

import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.client.api.configuration.agent.proxy.ProxyConfig;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;
import org.mule.tooling.client.internal.configuration.agent.ImmutableAgentConfiguration;

public interface AgentConfiguration {
    public URL getToolingApiUrl();

    public long getDefaultConnectTimeout();

    public long getDefaultReadTimeout();

    public Optional<SslConfiguration> getSslConfiguration();

    public Optional<ProxyConfig> getProxyConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private URL toolingApiUrl;
        private long defaultConnectionTimeout = 0L;
        private long defaultReadTimeout = 0L;
        private SslConfiguration sslConfiguration = null;
        private ProxyConfig proxyConfig = null;

        public Builder withToolingApiUrl(URL toolingApiUrl) {
            Objects.requireNonNull(toolingApiUrl, "toolingApiUrl cannot be null");
            this.toolingApiUrl = toolingApiUrl;
            return this;
        }

        public Builder withDefaultConnectionTimeout(long defaultConnectionTimeout) {
            Builder.checkArgument(defaultConnectionTimeout >= 0L, "defaultConnectionTimeout cannot be < 0");
            this.defaultConnectionTimeout = defaultConnectionTimeout;
            return this;
        }

        public Builder withDefaultReadTimeout(long defaultReadTimeout) {
            Builder.checkArgument(defaultReadTimeout >= 0L, "defaultReadTimeout cannot be < 0");
            this.defaultReadTimeout = defaultReadTimeout;
            return this;
        }

        public Builder withSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public Builder withProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public AgentConfiguration build() {
            return new ImmutableAgentConfiguration(this.toolingApiUrl, this.defaultConnectionTimeout, this.defaultReadTimeout, this.sslConfiguration, this.proxyConfig);
        }

        protected static void checkArgument(boolean expression, Object errorMessage) {
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }
}

