/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.XStream;

/**
 * Factory for {@link com.thoughtworks.xstream.XStream}.
 *
 * @since 1.0
 */
public final class XStreamFactory {

  private XStreamFactory() {}

  private static final String[] ALLOWED_TYPES = {
      "org.mule.**",
      "java.util.Optional",
      "com.google.**",
      "javax.xml.namespace.QName"
  };

  /**
   * @return an instance of {@link XStream} configured with the default settings (security and converters).
   */
  public static XStream createXStream() {
    final XStream xStream = new XStream();
    XStream.setupDefaultSecurity(xStream);
    xStream.allowTypesByWildcard(ALLOWED_TYPES);
    xStream.registerConverter(new DefaultArrayTypeConverter(xStream.getMapper()));
    return xStream;

  }

}
