/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.metadata;

import org.mule.metadata.api.model.MetadataType;

/**
 * Model for a {@link org.mule.tooling.client.api.extension.model.source.SourceModel} and
 * {@link org.mule.tooling.client.api.extension.model.operation.OperationModel} parameters
 * that indicates that its a {@code MetadataKeyId}.
 *
 * @since 1.0
 */
public class MetadataKeyIdModel {

  private MetadataType type;
  private String parameterName;

  // Just needed in order to serialize this object
  private MetadataKeyIdModel() {}

  /**
   * Creates a new instance.
   *
   * @param type of the {@link org.mule.tooling.client.api.extension.model.parameter.ParameterModel} annotated with {@code MetadataKeyId}.
   */
  public MetadataKeyIdModel(MetadataType type, String parameterName) {
    this.type = type;
    this.parameterName = parameterName;
  }

  /**
   * @return the type of the {@link org.mule.tooling.client.api.extension.model.parameter.ParameterModel} annotated with {@code MetadataKeyId}.
   */
  public MetadataType getType() {
    return type;
  }

  /**
   * @return the parameter name that is considered as the {@code MetadataKeyId}.
   */
  public String getParameterName() {
    return parameterName;
  }
}
