/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense;

import org.mule.tooling.client.api.component.location.ComponentLocation;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataComponent;

import java.util.Optional;

import static java.util.Optional.ofNullable;

public class DataSenseNotification {

  private DataSenseNotificationType type;
  private MetadataComponent metadataComponent;
  private String failingElement;
  private FailureCode failureCode;
  private I18nMessage message;
  private I18nMessage reason;
  private ComponentLocation componentLocation;

  private DataSenseNotification() {}

  public DataSenseNotification(DataSenseNotificationType type, MetadataComponent component, String failingElement,
                               FailureCode failureCode, I18nMessage message, I18nMessage reason,
                               ComponentLocation componentLocation) {
    this.type = type;
    this.metadataComponent = component;
    this.failingElement = failingElement;
    this.failureCode = failureCode;
    this.message = message;
    this.reason = reason;
    this.componentLocation = componentLocation;
  }


  public DataSenseNotificationType getNotificationType() {
    return type;
  }

  public Optional<ComponentLocation> getComponentLocation() {
    return ofNullable(componentLocation);
  }

  public Optional<MetadataComponent> getMetadataComponent() {
    return ofNullable(metadataComponent);
  }

  public Optional<String> getFailingElement() {
    return ofNullable(failingElement);
  }

  public Optional<FailureCode> getFailureCode() {
    return ofNullable(failureCode);
  }

  public I18nMessage getMessage() {
    return message;
  }

  public Optional<I18nMessage> getReason() {
    return ofNullable(reason);
  }

}
