/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import static org.mule.tooling.client.api.extension.model.PathModelLocation.anyPathModelLocation;
import static org.mule.tooling.client.api.extension.model.PathModelLocation.embeddedPathModelLocation;
import static org.mule.tooling.client.api.extension.model.PathModelLocation.externalPathModelLocation;
import org.mule.tooling.client.api.extension.model.PathModelLocation;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

/**
 * {@link TypeAdapter} for {@link PathModelLocation}.
 */
public class PathModelLocationTypeAdapter extends TypeAdapter<PathModelLocation> {

  @Override
  public void write(JsonWriter out, PathModelLocation pathModelLocation) throws IOException {
    out.value(pathModelLocation.getValue());
  }

  @Override
  public PathModelLocation read(JsonReader in) throws IOException {
    String location = in.nextString();
    switch (location) {
      case "EMBEDDED":
        return embeddedPathModelLocation(location);
      case "EXTERNAL":
        return externalPathModelLocation(location);
      case "ANY":
        return anyPathModelLocation(location);
      default:
        return new PathModelLocation(location);
    }
  }

}
