/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import static org.apache.commons.lang3.builder.EqualsBuilder.reflectionEquals;
import static org.apache.commons.lang3.builder.HashCodeBuilder.reflectionHashCode;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Represents an extension's capability to be mapped and usable
 * from a Mule XML config.
 *
 * @since 1.0
 */
public class XmlDslModel {

  private String xsdFileName = "";
  private String schemaVersion = "";
  private String prefix = "";
  private String namespace = "";
  private String schemaLocation = "";

  // Just needed in order to serialize this object
  private XmlDslModel() {}

  public XmlDslModel(String xsdFileName, String schemaVersion, String prefix, String namespace, String schemaLocation) {
    this.xsdFileName = xsdFileName;
    this.schemaVersion = schemaVersion;
    this.prefix = prefix;
    this.namespace = namespace;
    this.schemaLocation = schemaLocation;
  }

  /**
   * @return The version of the schema. Defaults to 1.0.
   */
  public String getSchemaVersion() {
    return schemaVersion;
  }

  /**
   * @return The extension's prefix
   */
  public String getPrefix() {
    return prefix;
  }

  /**
   * @return The namespace URI
   */
  public String getNamespace() {
    return namespace;
  }

  /**
   * @return The name of the schema file
   */
  public String getXsdFileName() {
    return xsdFileName;
  }

  /**
   * @return the location for the XSD schema
   */
  public String getSchemaLocation() {
    return schemaLocation;
  }

  public int hashCode() {
    return reflectionHashCode(this);
  }

  public boolean equals(Object obj) {
    return reflectionEquals(this, obj);
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this);
  }

}
