/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import org.mule.tooling.client.internal.datasense.DataSenseResolutionScopeVisitor;

/**
 * Defines the different types of scopes for data sense resolution.
 * This interface is not meant to be extended by clients.
 *
 * @since 1.0
 */
public interface DataSenseResolutionScope {

  /**
   * Allows to visit the scope hierarchy.
   *
   * @param {@link DataSenseResolutionScopeVisitor visitor}
   */
  void accept(DataSenseResolutionScopeVisitor visitor);

}
