/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.maven.client.test.MavenTestHelper;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.test.BootstrapVersionConfiguration;
import org.mule.tooling.client.test.junit4.ToolingJUnitTestRunner;
import org.mule.tooling.client.test.junit4.annotations.AgentPort;
import org.mule.tooling.client.test.junit4.annotations.AgentProtocol;
import org.mule.tooling.client.test.junit4.annotations.BootstrapVersions;
import org.mule.tooling.client.test.junit4.annotations.Log4JConfiguration;
import org.mule.tooling.client.test.junit4.annotations.MuleVersion;
import org.mule.tooling.client.test.junit4.annotations.RuntimeMavenConfiguration;
import org.mule.tooling.client.test.junit4.annotations.ToolingRuntimeBootstrap;
import org.mule.tooling.client.test.utils.CheckedConsumer;
import org.mule.tooling.client.test.utils.CheckedFunction;
import org.mule.tooling.client.test.utils.MavenUtils;

@RunWith(value=ToolingJUnitTestRunner.class)
public abstract class BaseToolingBootstrapTestCase {
    private static final String HTTP = "http";
    protected static final String AGENT_BASE_URL = "/mule/tooling";
    @ClassRule
    public static DynamicPort providedAgentPort = new DynamicPort("providedAgentPort");
    @MuleVersion
    protected static String muleVersion;
    @AgentPort
    protected static Integer agentPort;
    @AgentProtocol
    protected static String agentProtocol;
    @RuntimeMavenConfiguration
    protected static MavenConfiguration mavenConfiguration;
    @ToolingRuntimeBootstrap
    private static ToolingRuntimeClientBootstrap bootstrap;
    private final ToolingRuntimeClient defaultToolingRuntimeClient = this.getDefaultToolingClientBuilder().build();

    @AgentPort
    private static Integer provideAgentPort() {
        return providedAgentPort.getNumber();
    }

    @AgentProtocol
    private static String provideAgentProtocol() {
        return HTTP;
    }

    @RuntimeMavenConfiguration
    private static MavenConfiguration provideMavenConfiguration() throws Exception {
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenTestHelper.createDefaultEnterpriseMavenConfigurationBuilder().ignoreArtifactDescriptorRepositories(false);
        settingsSupplierFactory.environmentSettingsSecuritySupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    @Log4JConfiguration
    private static URI provideLog4JConfigFile() throws URISyntaxException {
        return Thread.currentThread().getContextClassLoader().getResource("log4j2-tooling.xml").toURI();
    }

    @BootstrapVersions
    private static List<BootstrapVersionConfiguration> provideBootstrapVersions() {
        return Collections.singletonList(new BootstrapVersionConfiguration(MavenUtils.getToolingVersion(), MavenUtils.getMuleVersion()));
    }

    protected ToolingRuntimeClient getDefaultToolingRuntimeClient() {
        return this.defaultToolingRuntimeClient;
    }

    protected ToolingRuntimeClient.Builder getDefaultToolingClientBuilder() {
        try {
            ToolingRuntimeClient.Builder toolingBuilder = bootstrap.getToolingRuntimeClientBuilderFactory().create();
            toolingBuilder.withMavenConfiguration(mavenConfiguration).withRemoteAgentConfiguration(AgentConfiguration.builder().withDefaultConnectionTimeout(6000L).withDefaultReadTimeout(60000L).withMuleVersion(muleVersion).withToolingApiUrl(new URL(agentProtocol, InetAddress.getLocalHost().getHostName(), agentPort, AGENT_BASE_URL)).build()).build();
            toolingBuilder.withTargetRuntimeVersion().ifEnabled(c -> c.perform((Object)muleVersion));
            return toolingBuilder;
        }
        catch (MalformedURLException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    protected ToolingRuntimeClient.Builder getBaseToolingClientBuilder() {
        return bootstrap.getToolingRuntimeClientBuilderFactory().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, URL artifactUrl, ToolingArtifact parent, Map<String, String> artifactProperties, CheckedConsumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = null;
        try {
            toolingArtifact = parent == null ? toolingRuntimeClient.newToolingArtifact(artifactUrl, artifactProperties) : toolingRuntimeClient.newToolingArtifact(artifactUrl, artifactProperties, parent.getId());
            consumer.accept(toolingArtifact);
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, URL artifactUrl, Map<String, String> artifactProperties, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(toolingRuntimeClient, artifactUrl, null, artifactProperties, consumer);
    }

    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, ToolingArtifact parent, Map<String, String> artifactProperties, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(toolingRuntimeClient, this.getUrl(artifactLocation), parent, artifactProperties, consumer);
    }

    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, ToolingArtifact parent, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(toolingRuntimeClient, artifactLocation, parent, Collections.emptyMap(), consumer);
    }

    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, Map<String, String> artifactProperties, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(toolingRuntimeClient, artifactLocation, null, artifactProperties, consumer);
    }

    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(toolingRuntimeClient, artifactLocation, null, Collections.emptyMap(), consumer);
    }

    protected void doWithToolingArtifact(String artifactLocation, Map<String, String> artifactProperties, ToolingArtifact parent, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, parent, artifactProperties, consumer);
    }

    protected void doWithToolingArtifact(String artifactLocation, ToolingArtifact parent, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, parent, consumer);
    }

    protected void doWithToolingArtifact(String artifactLocation, Map<String, String> artifactProperties, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, artifactProperties, consumer);
    }

    protected void doWithToolingArtifact(String artifactLocation, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, ToolingArtifact parent, Map<String, String> artifactProperties, CheckedFunction<ToolingArtifact, T> function) {
        ToolingArtifact toolingArtifact = null;
        try {
            URL artifactUrl = this.getUrl(artifactLocation);
            toolingArtifact = parent == null ? toolingRuntimeClient.newToolingArtifact(artifactUrl, artifactProperties) : toolingRuntimeClient.newToolingArtifact(artifactUrl, artifactProperties, parent.getId());
            T t = function.apply(toolingArtifact);
            return t;
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    protected <T> T doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, ToolingArtifact parent, CheckedFunction<ToolingArtifact, T> function) {
        return this.doWithToolingArtifact(toolingRuntimeClient, artifactLocation, parent, Collections.emptyMap(), function);
    }

    protected <T> T doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, Map<String, String> artifactProperties, CheckedFunction<ToolingArtifact, T> function) {
        return this.doWithToolingArtifact(toolingRuntimeClient, artifactLocation, null, artifactProperties, function);
    }

    protected <T> T doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String artifactLocation, CheckedFunction<ToolingArtifact, T> function) {
        return this.doWithToolingArtifact(toolingRuntimeClient, artifactLocation, null, Collections.emptyMap(), function);
    }

    protected <T> T doWithToolingArtifact(String artifactLocation, Map<String, String> artifactProperties, ToolingArtifact parent, CheckedFunction<ToolingArtifact, T> function) {
        return this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, parent, artifactProperties, function);
    }

    protected <T> T doWithToolingArtifact(String artifactLocation, ToolingArtifact parent, CheckedFunction<ToolingArtifact, T> function) {
        return this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, parent, function);
    }

    protected <T> T doWithToolingArtifact(String artifactLocation, Map<String, String> artifactProperties, CheckedFunction<ToolingArtifact, T> function) {
        return this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, artifactProperties, function);
    }

    protected <T> T doWithToolingArtifact(String artifactLocation, CheckedFunction<ToolingArtifact, T> function) {
        return this.doWithToolingArtifact(this.defaultToolingRuntimeClient, artifactLocation, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithFetchedToolingArtifact(String id, CheckedConsumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = null;
        try {
            toolingArtifact = this.defaultToolingRuntimeClient.fetchToolingArtifact(id);
            consumer.accept(toolingArtifact);
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    private URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while getting URL", e);
        }
    }

    private URL getUrl(String artifactLocation) {
        try {
            File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            File applicationLocation = new File(targetTestClassesFolder, artifactLocation);
            return this.toUrl(applicationLocation.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid artifact location");
        }
    }
}

