/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SystemPropertiesManager {
    private List<ImmutablePair<String, String>> systemProperties;
    private List<ImmutablePair<String, String>> previousProperties = new ArrayList<ImmutablePair<String, String>>();

    public SystemPropertiesManager(List<ImmutablePair<String, String>> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void set() {
        for (ImmutablePair<String, String> systemProperty : this.systemProperties) {
            String previousValue = this.setSystemProperty(systemProperty);
            this.previousProperties.add((ImmutablePair<String, String>)ImmutablePair.of((Object)systemProperty.getKey(), (Object)previousValue));
        }
    }

    public void unset() {
        for (ImmutablePair<String, String> previousProperty : this.previousProperties) {
            this.setSystemProperty(previousProperty);
        }
    }

    private String setSystemProperty(ImmutablePair<String, String> systemProperty) {
        String previousValue = systemProperty.getValue() != null ? System.setProperty((String)systemProperty.getKey(), (String)systemProperty.getValue()) : System.clearProperty((String)systemProperty.getKey());
        return previousValue;
    }
}

