/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.aether.concurrency;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;

import io.takari.filemanager.FileManager;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;

/**
 * Implementation to allow the usage of {@link io.takari.aether.concurrency.LockingSyncContextFactory} in Aether without
 * dependency injection.
 *
 * @since 1.0
 */
public class LockingSyncContextFactory implements SyncContextFactory, Service {

  private io.takari.aether.concurrency.LockingSyncContextFactory lockingSyncContextFactory;

  @Override
  public void initService(ServiceLocator locator) {
    final FileManager fileManager = locator.getService(FileManager.class);
    requireNonNull(fileManager, format("%s has to be registered in ServiceLocator", FileManager.class.getName()));

    lockingSyncContextFactory = new io.takari.aether.concurrency.LockingSyncContextFactory(fileManager);
  }

  @Override
  public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
    return lockingSyncContextFactory.newInstance(session, shared);
  }

}
