/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.application.ArtifactDeployer;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.application.FileSystemArtifactDeployer;
import org.mule.tooling.client.internal.application.InputStreamArtifactDeployer;

public final class RemoteArtifactContextFactory {
    public static ArtifactDeployer createRemoteArtifactContext(ArtifactResources artifactResources, Map<String, String> deploymentProperties, Supplier<RuntimeToolingService> runtimeToolingService) {
        Objects.requireNonNull(artifactResources, "artifactResources cannot be null");
        Objects.requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");
        if (!artifactResources.isRemote()) {
            return new FileSystemArtifactDeployer(artifactResources, runtimeToolingService, deploymentProperties);
        }
        return new InputStreamArtifactDeployer(artifactResources, runtimeToolingService, deploymentProperties);
    }
}

