/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.codehaus.plexus.util.ExceptionUtils;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.tooling.client.api.value.ValueResult;

public class ValueUtils {
    private static final String DEPLOYMENT = "DEPLOYMENT";

    public static ValueResult toValueResultDTO(org.mule.runtime.api.value.ValueResult valueResult) {
        HashSet<org.mule.tooling.client.api.value.Value> values = new HashSet<org.mule.tooling.client.api.value.Value>();
        for (Value value : valueResult.getValues()) {
            values.add(ValueUtils.toValueDTO(value));
        }
        return new ValueResult(values, ValueUtils.toResolvingFailureDTO(valueResult.getFailure()));
    }

    public static ValueResult toFailureValueResultDTO(Throwable t) {
        String failureCode = "UNKNOWN";
        if (t instanceof CompletionException && t.getCause() instanceof DeploymentException) {
            failureCode = DEPLOYMENT;
        }
        return new ValueResult(Collections.emptySet(), new org.mule.tooling.client.api.value.ResolvingFailure(t.getMessage(), ExceptionUtils.getStackTrace((Throwable)t), failureCode));
    }

    private static org.mule.tooling.client.api.value.Value toValueDTO(Value value) {
        HashSet<org.mule.tooling.client.api.value.Value> children = new HashSet<org.mule.tooling.client.api.value.Value>();
        for (Value child : value.getChilds()) {
            children.add(ValueUtils.toValueDTO(child));
        }
        return new org.mule.tooling.client.api.value.Value(value.getId(), value.getDisplayName(), value.getPartName(), children);
    }

    private static org.mule.tooling.client.api.value.ResolvingFailure toResolvingFailureDTO(Optional<ResolvingFailure> resolvingFailureOptional) {
        if (!resolvingFailureOptional.isPresent()) {
            return null;
        }
        ResolvingFailure resolvingFailure = resolvingFailureOptional.get();
        return new org.mule.tooling.client.api.value.ResolvingFailure(resolvingFailure.getMessage(), resolvingFailure.getReason(), resolvingFailure.getFailureCode());
    }
}

