/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.DataFormat;
import org.mule.runtime.api.el.DataFormatConfigOption;
import org.mule.runtime.api.el.ExpressionLanguageCapabilitiesService;
import org.mule.tooling.client.api.dataweave.DataWeaveModuleOption;

public class ModulesAnalyzer {
    private ExpressionLanguageCapabilitiesService expressionLanguageCapabilitiesService;

    public ModulesAnalyzer(ExpressionLanguageCapabilitiesService expressionLanguageCapabilitiesService) {
        this.expressionLanguageCapabilitiesService = expressionLanguageCapabilitiesService;
    }

    public List<DataWeaveModuleOption> getOptions(String contentType, Function<DataFormat, Set<DataFormatConfigOption>> getter) {
        this.expressionLanguageCapabilitiesService.getSupportedDataFormats();
        Optional<DataFormat> moduleOption = this.byContentType(contentType);
        if (moduleOption.isPresent()) {
            ArrayList<DataWeaveModuleOption> response = new ArrayList<DataWeaveModuleOption>();
            Set<DataFormatConfigOption> formatConfigOptions = getter.apply(moduleOption.get());
            formatConfigOptions.stream().forEach(option -> response.add(this.toRestModel((DataFormatConfigOption)option)));
            return response;
        }
        throw new IllegalArgumentException("Module for " + contentType + " not found");
    }

    private Optional<DataFormat> byContentType(String contentType) {
        return this.expressionLanguageCapabilitiesService.getSupportedDataFormats().stream().filter(dataFormat -> dataFormat.getSupportedMimeTypes().contains(contentType)).findFirst();
    }

    private DataWeaveModuleOption toRestModel(DataFormatConfigOption option) {
        DataWeaveModuleOption model = new DataWeaveModuleOption();
        model.setName(option.getName());
        model.setType(option.getType().toString());
        model.setDefaultValue(option.getDefaultValue().map(object -> object.toString()).orElse(""));
        model.setDescription(option.getDescription());
        model.setPossibleValues(option.getPossibleValues().stream().map(object -> object.toString()).collect(Collectors.joining(",")));
        return model;
    }
}

