/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.MuleMavenClientProvider;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.artifact.ArtifactDescriptorFactoryProvider;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.deployment.model.api.builder.DeployableArtifactClassLoaderFactoryProvider;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.globalconfig.api.maven.MavenClientFactory;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.tooling.client.internal.application.ApplicationClassLoaderFactory;
import org.mule.tooling.client.internal.application.DomainClassLoaderFactory;

public class MuleArtifactResourcesRegistry {
    private String toolingVersion;
    private Optional<MuleVersion> targetMuleVersion;
    private ModuleRepository moduleRepository;
    private final File workingDirectory;
    private AbstractArtifactDescriptorFactory<MulePluginModel, ArtifactPluginDescriptor> artifactPluginDescriptorFactory;
    private ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private PluginDependenciesResolver pluginDependenciesResolver;
    private ArtifactClassLoader containerArtifactClassLoader;
    private AbstractArtifactDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> applicationDescriptorFactory;
    private DomainDescriptorFactory domainDescriptorFactory;
    private RegionPluginClassLoadersFactory regionPluginClassLoadersFactory;
    private DomainClassLoaderFactory domainClassLoaderFactory;
    private ApplicationClassLoaderFactory applicationClassLoaderFactory;
    private DescriptorLoaderRepository descriptorLoaderRepository;

    public MuleArtifactResourcesRegistry(String toolingVersion, Optional<MuleVersion> targetMuleVersion, final MavenClient mavenClient, ModuleRepository moduleRepository, ArtifactClassLoader containerArtifactClassLoader, File workingDirectory) {
        this.toolingVersion = toolingVersion;
        this.targetMuleVersion = targetMuleVersion;
        this.moduleRepository = moduleRepository;
        this.containerArtifactClassLoader = containerArtifactClassLoader;
        this.workingDirectory = workingDirectory;
        MavenClientFactory.setMavenClientProvider(() -> new MuleMavenClientProvider(){

            public MavenClient createMavenClient(MavenConfiguration mavenConfiguration) {
                return mavenClient;
            }
        });
        this.init();
    }

    public DescriptorLoaderRepository getDescriptorLoaderRepository() {
        return this.descriptorLoaderRepository;
    }

    private void init() {
        this.descriptorLoaderRepository = new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository();
        ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder = ArtifactDescriptorValidatorBuilder.builder().validateMinMuleVersion().validateMinMuleVersion(() -> this.toolingVersion).validateMinMuleVersionUsingSemanticVersion();
        this.artifactPluginDescriptorFactory = ArtifactDescriptorFactoryProvider.artifactDescriptorFactoryProvider().createArtifactPluginDescriptorFactory(this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        this.artifactPluginDescriptorLoader = new ArtifactPluginDescriptorLoader(this.artifactPluginDescriptorFactory);
        this.applicationDescriptorFactory = ArtifactDescriptorFactoryProvider.artifactDescriptorFactoryProvider().createApplicationDescriptorFactory(this.artifactPluginDescriptorFactory, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        this.domainDescriptorFactory = new DomainDescriptorFactory(this.artifactPluginDescriptorLoader, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        this.regionPluginClassLoadersFactory = DeployableArtifactClassLoaderFactoryProvider.regionPluginClassLoadersFactory((ArtifactClassLoaderResolver)ArtifactClassLoaderResolver.classLoaderResolver((ArtifactClassLoader)this.containerArtifactClassLoader, (ModuleRepository)this.moduleRepository, name -> MuleFoldersUtil.getAppDataFolder((String)name)));
        this.pluginDependenciesResolver = ArtifactDescriptorFactoryProvider.artifactDescriptorFactoryProvider().createBundlePluginDependenciesResolver(this.artifactPluginDescriptorFactory);
        this.domainClassLoaderFactory = new DomainClassLoaderFactory(this.containerArtifactClassLoader, this.regionPluginClassLoadersFactory, this.pluginDependenciesResolver);
        this.applicationClassLoaderFactory = new ApplicationClassLoaderFactory(this.containerArtifactClassLoader, this.regionPluginClassLoadersFactory, this.pluginDependenciesResolver);
    }

    public Optional<MuleVersion> getTargetMuleVersion() {
        return this.targetMuleVersion;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public RegionPluginClassLoadersFactory getRegionPluginClassLoadersFactory() {
        return this.regionPluginClassLoadersFactory;
    }

    public DeployableArtifactClassLoaderFactory<ArtifactDescriptor> newTemporaryArtifactClassLoaderFactory() {
        return new TemporaryArtifactClassLoaderFactory();
    }

    public ArtifactClassLoader getContainerArtifactClassLoader() {
        return this.containerArtifactClassLoader;
    }

    public AbstractArtifactDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> getApplicationDescriptorFactory() {
        return this.applicationDescriptorFactory;
    }

    public DomainDescriptorFactory getDomainDescriptorFactory() {
        return this.domainDescriptorFactory;
    }

    public PluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    public ArtifactPluginDescriptorLoader getArtifactPluginDescriptorLoader() {
        return this.artifactPluginDescriptorLoader;
    }

    public DomainClassLoaderFactory getDomainClassLoaderFactory() {
        return this.domainClassLoaderFactory;
    }

    public ApplicationClassLoaderFactory getApplicationClassLoaderFactory() {
        return this.applicationClassLoaderFactory;
    }

    private class TemporaryArtifactClassLoaderFactory
    implements DeployableArtifactClassLoaderFactory<ArtifactDescriptor> {
        private TemporaryArtifactClassLoaderFactory() {
        }

        public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, ArtifactDescriptor descriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
            return new MuleDeployableArtifactClassLoader(artifactId, descriptor, descriptor.getClassLoaderConfiguration().getUrls(), parent.getClassLoader(), parent.getClassLoaderLookupPolicy(), artifactPluginClassLoaders);
        }
    }
}

