/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.DomainCache;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.SpiRuntimeToolingServiceProvider;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.application.ApplicationClassLoaderFactory;
import org.mule.tooling.client.internal.application.DomainClassLoaderFactory;
import org.mule.tooling.client.internal.cache.CacheStorageMapWrapperFactory;
import org.mule.tooling.client.internal.metadata.MetadataMediatorRuntimeToolingServiceDecorator;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.service.ServiceRegistry;

public class DefaultToolingArtifactContext
implements ToolingArtifactContext {
    private final MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;
    private final SpiRuntimeToolingServiceProvider runtimeToolingServiceProvider = new SpiRuntimeToolingServiceProvider();
    private volatile transient boolean runtimeToolingServiceInitialized;
    private RuntimeToolingService runtimeToolingService;
    private Optional<AgentConfiguration> agentConfigurationOptional;
    private ApplicationCache applicationCache;
    private DomainCache domainCache;
    private MavenClient mavenClient;
    private MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private Optional<MetadataCacheFactory> metadataCacheFactory;
    private Optional<CacheStorageMapWrapperFactory> metadataCacheStorageMapWrapperFactory;
    private Optional<CacheStorageMapWrapperFactory> valueProvidersCacheStorageMapWrapperFactory;
    private Serializer serializer;
    private ServiceRegistry serviceRegistry;

    public DefaultToolingArtifactContext(MuleArtifactResourcesRegistry muleArtifactResourcesRegistry) {
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
    }

    public void setAgentConfiguration(Optional<AgentConfiguration> agentConfigurationOptional) {
        this.agentConfigurationOptional = agentConfigurationOptional;
    }

    @Override
    public Optional<AgentConfiguration> getAgentConfiguration() {
        return this.agentConfigurationOptional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeToolingService getRuntimeToolingService() {
        if (!this.runtimeToolingServiceInitialized) {
            DefaultToolingArtifactContext defaultToolingArtifactContext = this;
            synchronized (defaultToolingArtifactContext) {
                if (!this.runtimeToolingServiceInitialized) {
                    this.runtimeToolingService = this.runtimeToolingServiceProvider.lookUpRuntimeToolingService();
                    if (!this.agentConfigurationOptional.isPresent()) {
                        throw new MissingToolingConfigurationException("Tooling Client has to be configured with a configuration to access REST Tooling API in order to resolve operations");
                    }
                    AgentConfiguration agentConfiguration = this.agentConfigurationOptional.get();
                    this.runtimeToolingService.setToolingApiUrl(agentConfiguration.getToolingApiUrl(), agentConfiguration.getDefaultConnectTimeout(), agentConfiguration.getDefaultReadTimeout(), agentConfiguration.getSslConfiguration(), agentConfiguration.getProxyConfig(), agentConfiguration.getAuthorizationToken());
                    this.runtimeToolingService.setMuleVersion((String)agentConfiguration.muleVersion().orElse(null));
                    this.muleArtifactResourcesRegistry.getTargetMuleVersion().ifPresent(targetMuleVersion -> {
                        this.runtimeToolingService = new MetadataMediatorRuntimeToolingServiceDecorator((MuleVersion)targetMuleVersion, this.runtimeToolingService);
                    });
                    this.runtimeToolingServiceInitialized = true;
                }
            }
        }
        return this.runtimeToolingService;
    }

    @Override
    public PluginDependenciesResolver getPluginDependenciesResolver() {
        return this.muleArtifactResourcesRegistry.getPluginDependenciesResolver();
    }

    @Override
    public ApplicationCache getApplicationCache() {
        return this.applicationCache;
    }

    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }

    @Override
    public DomainCache getDomainCache() {
        return this.domainCache;
    }

    public void setDomainCache(DomainCache domainCache) {
        this.domainCache = domainCache;
    }

    public void setMavenClient(MavenClient mavenClient) {
        this.mavenClient = mavenClient;
    }

    @Override
    public MavenClient getMavenClient() {
        return this.mavenClient;
    }

    public void setMuleRuntimeExtensionModelProvider(MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider) {
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
    }

    @Override
    public MuleRuntimeExtensionModelProvider getMuleRuntimeExtensionModelProvider() {
        return this.muleRuntimeExtensionModelProvider;
    }

    @Override
    public DomainClassLoaderFactory getDomainClassLoaderFactory() {
        return this.muleArtifactResourcesRegistry.getDomainClassLoaderFactory();
    }

    @Override
    public ApplicationClassLoaderFactory getApplicationClassLoaderFactory() {
        return this.muleArtifactResourcesRegistry.getApplicationClassLoaderFactory();
    }

    public DomainDescriptorFactory getDomainDescriptorFactory() {
        return this.muleArtifactResourcesRegistry.getDomainDescriptorFactory();
    }

    public AbstractArtifactDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> getApplicationDescriptorFactory() {
        return this.muleArtifactResourcesRegistry.getApplicationDescriptorFactory();
    }

    public void setMetadataCacheStorageFactory(Optional<CacheStorageMapWrapperFactory> metadataCacheFactory) {
        this.metadataCacheStorageMapWrapperFactory = metadataCacheFactory;
    }

    public void setValueProvidersCacheStorageFactory(Optional<CacheStorageMapWrapperFactory> valueProvidersCacheStorageFactory) {
        this.valueProvidersCacheStorageMapWrapperFactory = valueProvidersCacheStorageFactory;
    }

    public Optional<CacheStorageMapWrapperFactory> getMetadataCacheStorageMapWrapperFactory() {
        return this.metadataCacheStorageMapWrapperFactory;
    }

    public Optional<CacheStorageMapWrapperFactory> getValueProvidersCacheStorageMapWrapperFactory() {
        return this.valueProvidersCacheStorageMapWrapperFactory;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setMetadataCacheFactory(Optional<MetadataCacheFactory> metadataCacheFactoryOptional) {
        this.metadataCacheFactory = metadataCacheFactoryOptional;
    }

    public Optional<MetadataCacheFactory> getMetadataCacheFactory() {
        return this.metadataCacheFactory;
    }
}

