/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasenseapi.api.DataSenseElementInfo;
import org.mule.datasenseapi.api.DataSenseInfo;
import org.mule.datasenseapi.api.notifications.DataSenseNotification;
import org.mule.datasenseapi.api.notifications.DataSenseNotificationType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.tooling.client.api.datasense.DataSenseComponentInfo;
import org.mule.tooling.client.api.datasense.DataSenseInfo;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataComponent;
import org.mule.tooling.client.internal.ComponentLocationFactory;
import org.mule.tooling.client.internal.ExtensionModelPartsFactory;
import org.mule.tooling.client.internal.LocationFactory;
import org.mule.tooling.client.internal.MetadataPartsFactory;

public class DataSensePartsFactory {
    private ExtensionModelPartsFactory extensionModelPartsFactory = new ExtensionModelPartsFactory();

    private org.mule.tooling.client.api.datasense.DataSenseNotificationType toDataSenseNotificationTypeDTO(DataSenseNotificationType type) {
        if (type == DataSenseNotificationType.ERROR) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.errorDataSenseNotificationType((String)type.name());
        }
        if (type == DataSenseNotificationType.FATAL_ERROR) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.fatalErrorDataSenseNotificationType((String)type.name());
        }
        if (type == DataSenseNotificationType.INFO) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.infoDataSenseNotificationType((String)type.name());
        }
        if (type == DataSenseNotificationType.WARNING) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.warningDataSenseNotificationType((String)type.name());
        }
        return new org.mule.tooling.client.api.datasense.DataSenseNotificationType(type.name());
    }

    private org.mule.tooling.client.api.datasense.DataSenseNotification toDataSenseNotificationDTO(DataSenseNotification notification) {
        MetadataComponent component = notification.getMetadataComponent().isPresent() ? MetadataPartsFactory.toMetadataComponentDTO((org.mule.runtime.api.metadata.resolving.MetadataComponent)notification.getMetadataComponent().get()) : null;
        I18nMessage reason = notification.getReason().orElse(null);
        org.mule.tooling.client.api.datasense.I18nMessage reasonDTO = notification.getReason().isPresent() ? new org.mule.tooling.client.api.datasense.I18nMessage(reason.getMessage(), reason.getCode(), reason.getArgs()) : null;
        FailureCode failureCode = notification.getFailureCode().isPresent() ? MetadataPartsFactory.failureCodeToDTO((org.mule.runtime.api.metadata.resolving.FailureCode)notification.getFailureCode().get()) : null;
        org.mule.tooling.client.api.component.location.ComponentLocation componentLocationDTO = null;
        if (notification.getComponentLocation().isPresent()) {
            ComponentLocation componentLocation = (ComponentLocation)notification.getComponentLocation().get();
            componentLocationDTO = new org.mule.tooling.client.api.component.location.ComponentLocation(componentLocation.getLocation(), ComponentLocationFactory.toTypedComponentIdentifierDTO(componentLocation.getComponentIdentifier()), ComponentLocationFactory.toLocationPartsDTO(componentLocation.getParts()), ComponentLocationFactory.toSourceCodeLocationDTO(componentLocation));
        }
        return new org.mule.tooling.client.api.datasense.DataSenseNotification(this.toDataSenseNotificationTypeDTO(notification.getNotificationType()), component, (String)notification.getFailingElement().orElse(null), failureCode, new org.mule.tooling.client.api.datasense.I18nMessage(notification.getMessage().getMessage(), notification.getMessage().getCode(), notification.getMessage().getArgs()), reasonDTO, componentLocationDTO);
    }

    private List<org.mule.tooling.client.api.datasense.DataSenseNotification> toDataSenseMNotificationsDTO(List<DataSenseNotification> notifications) {
        return notifications.stream().map(dataSenseNotification -> this.toDataSenseNotificationDTO((DataSenseNotification)dataSenseNotification)).collect(Collectors.toList());
    }

    private org.mule.tooling.client.api.datasense.DataSenseElementInfo toDataSenseElementInfoDTO(DataSenseElementInfo dataSenseElementInfo) {
        return org.mule.tooling.client.api.datasense.DataSenseElementInfo.newBuilder().withLocation(LocationFactory.toLocationDTO(dataSenseElementInfo.getLocation())).withExpected((MetadataType)dataSenseElementInfo.getExpected().orElse(null)).withExpectedOutput((MetadataType)dataSenseElementInfo.getExpectedOutput().orElse(null)).withActualOutput((MetadataType)dataSenseElementInfo.getActualOutput().orElse(null)).withInput((MetadataType)dataSenseElementInfo.getInput().orElse(null)).withOutput((MetadataType)dataSenseElementInfo.getOutput().orElse(null)).withIncoming((MetadataType)dataSenseElementInfo.getIncoming().orElse(null)).withResult((MetadataType)dataSenseElementInfo.getResult().orElse(null)).withMessages(dataSenseElementInfo.getMessages()).withExpectedInput((MetadataType)dataSenseElementInfo.getExpectedInput().orElse(null)).withActualInput((MetadataType)dataSenseElementInfo.getActualInput().orElse(null)).build();
    }

    public Optional<org.mule.tooling.client.api.datasense.DataSenseInfo> toDataSenseInfoDTO(Optional<DataSenseInfo> dataSenseInfoOptional) {
        if (!dataSenseInfoOptional.isPresent()) {
            return Optional.empty();
        }
        DataSenseInfo dataSenseInfo = dataSenseInfoOptional.get();
        HashMap componentInfoByComponentPath = new HashMap();
        if (dataSenseInfo.getComponentInfoByComponentPath().isPresent()) {
            ((Map)dataSenseInfo.getComponentInfoByComponentPath().get()).entrySet().stream().forEach(entry -> componentInfoByComponentPath.put(LocationFactory.toLocationDTO((Location)entry.getKey()), this.toDataSenseElementInfoDTO((DataSenseElementInfo)entry.getValue())));
        }
        DataSenseInfo.Builder builder = org.mule.tooling.client.api.datasense.DataSenseInfo.newBuilder().withLocation(LocationFactory.toLocationDTO(dataSenseInfo.getLocation())).withActualInput((MetadataType)dataSenseInfo.getActualInput().orElse(null)).withActualOutput((MetadataType)dataSenseInfo.getActualOutput().orElse(null)).withExpected((MetadataType)dataSenseInfo.getExpected().orElse(null)).withExpectedInput((MetadataType)dataSenseInfo.getExpectedInput().orElse(null)).withExpectedOutput((MetadataType)dataSenseInfo.getExpectedOutput().orElse(null)).withIncoming((MetadataType)dataSenseInfo.getIncoming().orElse(null)).withInput((MetadataType)dataSenseInfo.getInput().orElse(null)).withOutput((MetadataType)dataSenseInfo.getOutput().orElse(null)).withResult((MetadataType)dataSenseInfo.getResult().orElse(null)).withOperationModel(this.extensionModelPartsFactory.toOperationModelDTO(dataSenseInfo.getOperationModel().orElse(null))).withSourceModel(this.extensionModelPartsFactory.toSourceModelDTO(dataSenseInfo.getSourceModel().orElse(null))).withMessages(dataSenseInfo.getMessages()).withComponentInfoByComponentPath(componentInfoByComponentPath).withNotifications(this.toDataSenseMNotificationsDTO(dataSenseInfo.getDataSenseNotifications()));
        HashMap globalBindings = new HashMap();
        if (dataSenseInfo.getGlobalBindings() != null) {
            dataSenseInfo.getGlobalBindings().entrySet().stream().forEach(entry -> globalBindings.put((String)entry.getKey(), (MetadataType)entry.getValue()));
        }
        if (!globalBindings.isEmpty()) {
            builder.withGlobalBindings(globalBindings);
        }
        HashMap functionBindings = new HashMap();
        if (dataSenseInfo.getFunctionBindings() != null) {
            dataSenseInfo.getFunctionBindings().entrySet().stream().forEach(entry -> functionBindings.put((String)entry.getKey(), (MetadataType)entry.getValue()));
        }
        if (!functionBindings.isEmpty()) {
            builder.withFunctionBindings(functionBindings);
        }
        return Optional.of(builder.build());
    }

    public Optional<DataSenseComponentInfo> toDataSenseComponentInfoDTO(Optional<org.mule.datasenseapi.api.DataSenseComponentInfo> dataSenseComponentInfoOptional) {
        if (!dataSenseComponentInfoOptional.isPresent()) {
            return Optional.empty();
        }
        org.mule.datasenseapi.api.DataSenseComponentInfo dataSenseComponentInfo = dataSenseComponentInfoOptional.get();
        return Optional.of(new DataSenseComponentInfo(this.extensionModelPartsFactory.toOperationModelDTO(dataSenseComponentInfo.getOperationModel().orElse(null)), this.extensionModelPartsFactory.toSourceModelDTO(dataSenseComponentInfo.getSourceModel().orElse(null)), dataSenseComponentInfo.getMessages(), this.toDataSenseMNotificationsDTO(dataSenseComponentInfo.getDataSenseNotifications())));
    }
}

