/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.cache;

import java.util.Map;
import java.util.concurrent.Callable;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.tooling.client.internal.metadata.ToolingCacheIdGenerator;
import org.mule.tooling.client.internal.session.cache.DeclarationValueProviderCache;
import org.mule.tooling.client.internal.utils.FunctionalUtils;

public class DefaultDeclarationValueProviderCache
implements DeclarationValueProviderCache {
    private final Map<String, ValueResult> storage;
    private final ToolingCacheIdGenerator<ElementDeclaration> cacheIdGenerator;

    public DefaultDeclarationValueProviderCache(ToolingCacheIdGenerator<ElementDeclaration> cacheIdGenerator, Map<String, ValueResult> storage) {
        this.cacheIdGenerator = cacheIdGenerator;
        this.storage = storage;
    }

    @Override
    public ValueResult getValues(ElementDeclaration elementDeclaration, String parameterName, Callable<ValueResult> callable, boolean forceResolution) {
        return this.cacheIdGenerator.getIdForResolvedValues(elementDeclaration, parameterName).map(k -> {
            ValueResult result;
            if (forceResolution) {
                this.storage.keySet().remove(k);
            }
            if (this.storage.containsKey(k)) {
                try {
                    result = this.storage.get(k);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Exception result2) {
                    // empty catch block
                }
            }
            if ((result = FunctionalUtils.executeHandling(callable, e -> ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).build()))).isSuccess()) {
                this.storage.put((String)k, result);
            }
            return result;
        }).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't create a value provider cache id for component: %s, from extension: %s", elementDeclaration.getName(), elementDeclaration.getDeclaringExtension())));
    }

    @Override
    public ValueResult getValues(ElementDeclaration elementDeclaration, String parameterName, String targetSelector, Callable<ValueResult> callable, boolean forceResolution) {
        return this.cacheIdGenerator.getIdForResolvedValues(elementDeclaration, parameterName, targetSelector).map(k -> {
            ValueResult result;
            if (forceResolution) {
                this.storage.keySet().remove(k);
            }
            if (this.storage.containsKey(k)) {
                try {
                    result = this.storage.get(k);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Exception result2) {
                    // empty catch block
                }
            }
            if ((result = FunctionalUtils.executeHandling(callable, e -> ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).build()))).isSuccess()) {
                this.storage.put((String)k, result);
            }
            return result;
        }).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't create a field value provider cache id for component: %s, from extension: %s", elementDeclaration.getName(), elementDeclaration.getDeclaringExtension())));
    }
}

