/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.application.ArtifactDeployer;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactDeployer
implements ArtifactDeployer {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ArtifactResources artifactResources;
    private Supplier<RuntimeToolingService> runtimeToolingService;
    private Map<String, String> deploymentProperties;

    public AbstractArtifactDeployer(ArtifactResources artifactResources, Supplier<RuntimeToolingService> runtimeToolingService, Map<String, String> deploymentProperties) {
        Objects.requireNonNull(artifactResources, "artifactResources cannot be null");
        Objects.requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");
        Objects.requireNonNull(deploymentProperties, "deploymentProperties cannot be null");
        this.artifactResources = artifactResources;
        this.runtimeToolingService = runtimeToolingService;
        this.deploymentProperties = deploymentProperties;
    }

    @Override
    public final String deploy(String domainId) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Deploying artifact to Mule Runtime");
        }
        String artifactId = this.doInternalDeploy(this.artifactResources, this.runtimeToolingService.get(), domainId, this.deploymentProperties);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Application deployed with artifactId: {}", (Object)artifactId);
        }
        return artifactId;
    }

    @Override
    public final void dispose(String id) {
        this.doInternalDispose(id, this.runtimeToolingService.get());
    }

    protected abstract String doInternalDeploy(ArtifactResources var1, RuntimeToolingService var2, String var3, Map<String, String> var4);

    protected abstract void doInternalDispose(String var1, RuntimeToolingService var2);

    class DeploymentContext {
        private String artifactId;
        private File localLocation;
        private InputStream content;
        private String domainId;
        private Map<String, String> deploymentProperties;
        private RuntimeToolingService runtimeToolingService;

        DeploymentContext(String artifactId, RuntimeToolingService runtimeToolingService) {
            this.artifactId = artifactId;
            this.runtimeToolingService = runtimeToolingService;
        }

        DeploymentContext(String artifactId, InputStream content, String domainId, Map<String, String> deploymentProperties, RuntimeToolingService runtimeToolingService) {
            this.artifactId = artifactId;
            this.content = content;
            this.domainId = domainId;
            this.runtimeToolingService = runtimeToolingService;
            this.deploymentProperties = deploymentProperties;
        }

        DeploymentContext(String artifactId, File localLocation, String domainId, Map<String, String> deploymentProperties, RuntimeToolingService runtimeToolingService) {
            this.artifactId = artifactId;
            this.localLocation = localLocation;
            this.domainId = domainId;
            this.runtimeToolingService = runtimeToolingService;
            this.deploymentProperties = deploymentProperties;
        }

        public File getLocalLocation() {
            return this.localLocation;
        }

        public InputStream getContent() {
            return this.content;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public RuntimeToolingService getRuntimeToolingService() {
            return this.runtimeToolingService;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public Map<String, String> getDeploymentProperties() {
            return this.deploymentProperties;
        }
    }
}

