/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.mule.tooling.client.api.exception.ToolingException;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static <T> T executeHandlingException(ResourceSupplier<T> supplier) {
        try {
            return supplier.getResource();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ToolingException) {
                throw (ToolingException)e.getCause();
            }
            throw new ToolingException((Throwable)e);
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), ToolingException.class);
            throw new ToolingException((Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface ResourceSupplier<T> {
        public T getResource() throws ExecutionException;
    }
}

