/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.cache;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.map.AbstractMapDecorator;
import org.apache.commons.collections4.set.AbstractSetDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCMapDecorator<K, V>
extends AbstractMapDecorator<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCMapDecorator.class);
    private Optional<Method> setContextMapMethod;

    public MDCMapDecorator(Map<K, V> delegate) {
        super(delegate);
        ClassLoader classLoader = delegate.getClass().getClassLoader();
        try {
            this.setContextMapMethod = Optional.of(classLoader.loadClass(MDC.class.getName()).getMethod("setContextMap", Map.class));
        }
        catch (Exception e) {
            LOGGER.error(String.format("Could not get MDC class or method setContextMap from class loader: %s. MDC context won't be propagated when calling cache storage. Cause: %s", classLoader, e.getMessage()));
        }
    }

    private void setMDCContextMap() {
        this.setContextMapMethod.ifPresent(method -> {
            try {
                method.invoke(null, MDC.getCopyOfContextMap());
            }
            catch (Exception e) {
                LOGGER.error(String.format("Error calling setContextMap method on MDC. MDC context won't be propageted for tracing on cache storage invocation. Cause: %s", e.getMessage()));
            }
        });
    }

    public V get(Object key) {
        this.setMDCContextMap();
        return (V)super.get(key);
    }

    public V put(K key, V value) {
        this.setMDCContextMap();
        return (V)super.put(key, value);
    }

    public boolean containsKey(Object key) {
        this.setMDCContextMap();
        return super.containsKey(key);
    }

    public Set<K> keySet() {
        this.setMDCContextMap();
        return new MDCSetDecorator(super.keySet());
    }

    private class MDCSetDecorator
    extends AbstractSetDecorator<K> {
        public MDCSetDecorator(Set<K> delegate) {
            super(delegate);
        }

        public Iterator<K> iterator() {
            final Iterator delegate = super.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public K next() {
                    return delegate.next();
                }

                @Override
                public void remove() {
                    MDCMapDecorator.this.setMDCContextMap();
                    delegate.remove();
                }
            };
        }

        public boolean remove(Object object) {
            MDCMapDecorator.this.setMDCContextMap();
            return super.remove(object);
        }

        public boolean removeIf(Predicate<? super K> filter) {
            MDCMapDecorator.this.setMDCContextMap();
            return this.decorated().removeIf(filter);
        }

        public boolean removeAll(Collection<?> coll) {
            MDCMapDecorator.this.setMDCContextMap();
            return super.removeAll(coll);
        }
    }
}

