/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDomainMetadataProvider
implements MetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RemoteDomainInvoker remoteDomainInvoker;

    public InternalDomainMetadataProvider(RemoteDomainInvoker remoteDomainInvoker) {
        Preconditions.checkNotNull((Object)remoteDomainInvoker, (Object)"remoteDomainInvoker cannot be null");
        this.remoteDomainInvoker = remoteDomainInvoker;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting metadata keys for: {} on domain: {}", (Object)metadataKeysRequest, (Object)this.remoteDomainInvoker);
        }
        try {
            return this.remoteDomainInvoker.evaluateWithRemoteDomain((domainId, runtimeToolingService) -> runtimeToolingService.getMetadataKeysDomain(domainId, metadataKeysRequest.getLocation().toString(), metadataKeysRequest.getRequestTimeout()));
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onKeys()});
        }
    }

    @Override
    public void disposeMetadataCache(String hashKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Dispose metadata cache for hashKey: {} on domain: {}", (Object)hashKey, (Object)this.remoteDomainInvoker);
        }
        this.remoteDomainInvoker.evaluateWithRemoteDomain((applicationId, runtimeToolingService) -> {
            runtimeToolingService.disposeDomainMetadataCache(applicationId, hashKey);
            return null;
        });
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(MetadataProvider.MetadataRequest metadataRequest) {
        throw new UnsupportedOperationException("Metadata for operations cannot be retrieved on domain artifact");
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(MetadataProvider.MetadataRequest metadataRequest) {
        throw new UnsupportedOperationException("Metadata for sources cannot be retrieved on domain artifact");
    }
}

