/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.ast.ComponentGenerationInformation;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.resources.ResourceLoader;
import org.mule.tooling.client.api.component.location.ComponentLocationService;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.error.ErrorType;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.sampledata.SampleDataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.ApplicationConnectivityTestingService;
import org.mule.tooling.client.internal.ApplicationValueProviderService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.ComponentLocationFactory;
import org.mule.tooling.client.internal.DefaultComponentLocationService;
import org.mule.tooling.client.internal.DefaultDataSenseService;
import org.mule.tooling.client.internal.DomainConnectivityTestingService;
import org.mule.tooling.client.internal.DomainValueProviderService;
import org.mule.tooling.client.internal.ExtensionModelFactory;
import org.mule.tooling.client.internal.ExtensionModelPartsFactory;
import org.mule.tooling.client.internal.InternalApplicationMetadataProvider;
import org.mule.tooling.client.internal.InternalDomainMetadataProvider;
import org.mule.tooling.client.internal.SampleDataProviderServiceAdapter;
import org.mule.tooling.client.internal.ToolingMetadataServiceAdapter;
import org.mule.tooling.client.internal.UnavailableDataSenseService;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;
import org.mule.tooling.client.internal.artifact.DefaultResourceLoader;
import org.mule.tooling.client.internal.datasense.DataSenseArtifact;
import org.mule.tooling.client.internal.dataweave.ApplicationRemoteRunner;
import org.mule.tooling.client.internal.dataweave.DefaultDataWeaveService;
import org.mule.tooling.client.internal.dataweave.DomainRemoteRunner;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.dsl.DefaultDslSyntaxResolverService;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.service.ServiceRegistry;
import org.mule.tooling.client.internal.values.ValueProviderCache;

public class DefaultToolingArtifact
implements ToolingArtifact,
Command {
    private final String id;
    private final Artifact artifact;
    private final Serializer serializer;
    private final Optional<MuleVersion> targetRuntimeVersion;
    private final ConnectivityTestingService connectivityTestingService;
    private final MetadataService metadataService;
    private final DataSenseService dataSenseService;
    private final DataWeaveService dataWeaveService;
    private final ValueProviderService valueProviderService;
    private final Feature<SampleDataService> sampleDataService;
    private final ComponentLocationService componentLocationService;
    private ToolingArtifact parentToolingArtifact;

    public DefaultToolingArtifact(String id, Application application, ToolingArtifact parentToolingArtifact, Serializer serializer, ServiceRegistry serviceRegistry, LazyValue<MetadataCache> metadataCache, LazyValue<MetadataCache> parentMetadataCache, LazyValue<DslResolvingContext> dslResolvingContext, LazyValue<ComponentLocator<ComponentAst>> componentLocator, LazyValue<ValueProviderCache> valueProvidersCache, Optional<MuleVersion> targetRuntimeVersion) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)application, (Object)"application cannot be null");
        Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        Preconditions.checkNotNull((Object)serviceRegistry, (Object)"serviceRegistry cannot be null");
        Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        Preconditions.checkNotNull(dslResolvingContext, (Object)"dslResolvingContext cannot be null");
        Preconditions.checkNotNull(componentLocator, (Object)"component locator cannot be null");
        this.id = id;
        this.artifact = application;
        this.parentToolingArtifact = parentToolingArtifact;
        this.serializer = serializer;
        this.targetRuntimeVersion = targetRuntimeVersion;
        InternalApplicationMetadataProvider metadataProvider = new InternalApplicationMetadataProvider(application);
        ApplicationRemoteRunner remoteRunner = new ApplicationRemoteRunner(application);
        this.connectivityTestingService = new ApplicationConnectivityTestingService(application, serializer);
        this.metadataService = new ToolingMetadataServiceAdapter((LazyValue<ArtifactAst>)new LazyValue(this::getAst), metadataProvider, metadataCache, serializer, dslResolvingContext, componentLocator);
        DataSenseArtifact parentDataSenseArtifact = application.getDomain().map(domain -> new DataSenseArtifact((Artifact)domain, parentMetadataCache, new InternalDomainMetadataProvider((RemoteDomainInvoker)domain), domain.getProperties(), serviceRegistry.getExpressionLanguageMetadataService(), serviceRegistry.getApikitMetadataService(), null)).orElse(null);
        DataSenseArtifact dataSenseArtifact = new DataSenseArtifact(application, metadataCache, metadataProvider, application.getProperties(), serviceRegistry.getExpressionLanguageMetadataService(), serviceRegistry.getApikitMetadataService(), parentDataSenseArtifact);
        this.dataSenseService = new DefaultDataSenseService(dataSenseArtifact, serializer);
        this.valueProviderService = new ApplicationValueProviderService(application, () -> this.artifact.getExtensionModels(), serializer, valueProvidersCache, componentLocator);
        this.sampleDataService = Feature.enabled((Object)new SampleDataProviderServiceAdapter(application, serializer));
        this.dataWeaveService = new DefaultDataWeaveService((LazyValue<ClassLoader>)new LazyValue(() -> this.artifact.getArtifactClassLoader().getClassLoader()), remoteRunner, serviceRegistry.getExpressionLanguageMetadataService(), new ModulesAnalyzer(serviceRegistry.getExpressionLanguageCapabilitiesService()), serializer);
        this.componentLocationService = new DefaultComponentLocationService((LazyValue<ArtifactAst>)new LazyValue(this::getAst), serializer);
    }

    public DefaultToolingArtifact(String id, Domain domain, Serializer serializer, ServiceRegistry serviceRegistry, LazyValue<MetadataCache> metadataCache, LazyValue<DslResolvingContext> dslResolvingContext, LazyValue<ComponentLocator<ComponentAst>> componentLocator, LazyValue<ValueProviderCache> valueProvidersCache, Optional<MuleVersion> targetRuntimeVersion) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)domain, (Object)"domain cannot be null");
        Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        Preconditions.checkNotNull((Object)serviceRegistry, (Object)"serviceRegistry cannot be null");
        Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        Preconditions.checkNotNull(dslResolvingContext, (Object)"dslResolvingContext cannot be null");
        Preconditions.checkNotNull(componentLocator, (Object)"component locator cannot be null");
        Preconditions.checkNotNull(valueProvidersCache, (Object)"value providers cache cannot be null");
        this.id = id;
        this.artifact = domain;
        this.serializer = serializer;
        this.targetRuntimeVersion = targetRuntimeVersion;
        InternalDomainMetadataProvider metadataProvider = new InternalDomainMetadataProvider(domain);
        DomainRemoteRunner remoteRunner = new DomainRemoteRunner(domain);
        this.connectivityTestingService = new DomainConnectivityTestingService(domain, serializer);
        this.dataSenseService = new UnavailableDataSenseService(ArtifactType.DOMAIN);
        this.metadataService = new ToolingMetadataServiceAdapter((LazyValue<ArtifactAst>)new LazyValue(this::getAst), metadataProvider, metadataCache, serializer, dslResolvingContext, componentLocator);
        this.valueProviderService = new DomainValueProviderService(domain, () -> this.artifact.getExtensionModels(), serializer, valueProvidersCache, componentLocator);
        this.sampleDataService = Feature.disabled();
        this.dataWeaveService = new DefaultDataWeaveService((LazyValue<ClassLoader>)new LazyValue(() -> this.artifact.getArtifactClassLoader().getClassLoader()), remoteRunner, serviceRegistry.getExpressionLanguageMetadataService(), new ModulesAnalyzer(serviceRegistry.getExpressionLanguageCapabilitiesService()), serializer);
        this.componentLocationService = new DefaultComponentLocationService((LazyValue<ArtifactAst>)new LazyValue(this::getAst), serializer);
    }

    public String getId() {
        return this.id;
    }

    public Optional<ToolingArtifact> getParent() {
        return Optional.ofNullable(this.parentToolingArtifact);
    }

    public Map<String, String> getProperties() {
        return this.artifact.getProperties();
    }

    public ConnectivityTestingService connectivityTestingService() {
        return this.connectivityTestingService;
    }

    public MetadataService metadataService() {
        return this.metadataService;
    }

    public DataSenseService dataSenseService() {
        return this.dataSenseService;
    }

    public DataWeaveService dataWeaveService() {
        return this.dataWeaveService;
    }

    public ValueProviderService valueProviderService() {
        return this.valueProviderService;
    }

    public Feature<SampleDataService> sampleDataService() {
        return this.sampleDataService;
    }

    public Feature<ResourceLoader> getResourceLoader() {
        return Feature.enabled((Object)new DefaultResourceLoader(this.artifact, this.serializer));
    }

    public ComponentLocationService componentLocationService() {
        return this.componentLocationService;
    }

    public org.mule.tooling.client.api.artifact.ast.ArtifactAst getArtifactAst() {
        ArtifactAst ast = this.getAst();
        try {
            return this.toArtifactAstDto(ast);
        }
        catch (Exception e) {
            throw new ToolingException(String.format("Error while creating a DTO from the ArtifactAst of artifact %s", this.id), (Throwable)e);
        }
    }

    private org.mule.tooling.client.api.artifact.ast.ArtifactAst toArtifactAstDto(ArtifactAst ast) {
        Map dependencies = ast.dependencies().stream().map(em -> new ExtensionModelFactory(this.targetRuntimeVersion).createExtensionModel((org.mule.runtime.api.meta.model.ExtensionModel)em, this.artifact.getMinMuleVersion().toString())).collect(Collectors.toMap(em -> em.getName(), UnaryOperator.identity()));
        return new org.mule.tooling.client.api.artifact.ast.ArtifactAst((org.mule.tooling.client.api.artifact.ast.ArtifactAst)ast.getParent().map(this::toArtifactAstDto).orElse(null), new HashSet(dependencies.values()), this.toErrorTypeRepositoryDto(ast.getErrorTypeRepository()), ast.topLevelComponentsStream().map(comp -> this.toComponentAstDto((ComponentAst)comp, dependencies)).collect(Collectors.toList()));
    }

    private org.mule.tooling.client.api.error.ErrorTypeRepository toErrorTypeRepositoryDto(ErrorTypeRepository errorTypesRepo) {
        Set errorTypes = errorTypesRepo.getErrorTypes().stream().map(DefaultToolingArtifact::toErrorTypeDTO).collect(Collectors.toSet());
        Set internalErrorTypes = errorTypesRepo.getInternalErrorTypes().stream().map(DefaultToolingArtifact::toErrorTypeDTO).collect(Collectors.toSet());
        return new org.mule.tooling.client.api.error.ErrorTypeRepository(errorTypes, internalErrorTypes, errorTypesRepo.getErrorNamespaces());
    }

    private static ErrorType toErrorTypeDTO(org.mule.runtime.api.message.ErrorType errorType) {
        if (errorType == null) {
            return null;
        }
        return new ErrorType(errorType.getIdentifier(), errorType.getNamespace(), DefaultToolingArtifact.toErrorTypeDTO(errorType.getParentErrorType()));
    }

    private org.mule.tooling.client.api.artifact.ast.ComponentAst toComponentAstDto(ComponentAst ast, Map<String, ExtensionModel> dependencies) {
        ExtensionModel extension = dependencies.get(ast.getExtensionModel().getName());
        org.mule.tooling.client.api.extension.model.ParameterizedModel model = this.resolveModel(ast, extension);
        List params = model != null ? ast.getParameters().stream().map(p -> this.toComponentParameterAstDto(model, (ComponentParameterAst)p, dependencies)).collect(Collectors.toList()) : (ast.getType() != null ? ast.getModel(ParameterizedModel.class).map(asPmzd -> ast.getParameters().stream().map(p -> this.toComponentParameterAstDto(new org.mule.tooling.client.api.extension.model.ParameterizedModel(){
            final /* synthetic */ ParameterizedModel val$asPmzd;
            {
                this.val$asPmzd = parameterizedModel;
            }

            public List<ParameterGroupModel> getParameterGroupModels() {
                return ExtensionModelPartsFactory.toParameterGroupModelsDTO(pm -> Optional.empty(), this.val$asPmzd.getParameterGroupModels());
            }

            public Optional<ParameterGroupModel> getParameterGroupModel(String name) {
                return this.getParameterGroupModels().stream().filter(pgm -> pgm.getName().equals(name)).findAny();
            }
        }, (ComponentParameterAst)p, dependencies)).collect(Collectors.toList())).orElse(Collections.emptyList()) : Collections.emptyList());
        return new org.mule.tooling.client.api.artifact.ast.ComponentAst((String)ast.getComponentId().orElse(null), ComponentLocationFactory.toComponentTypeToDTO(ast.getComponentType()), extension, new ComponentGenerationInformation((DslElementSyntax)ast.getGenerationInformation().getSyntax().map(stx -> DefaultDslSyntaxResolverService.toDslDto(stx)).orElse(null)), ComponentLocationFactory.toComponentIdentifierDTO(ast.getIdentifier()), ComponentLocationFactory.toComponentLocationDTO(ast.getLocation()), ComponentLocationFactory.toSourceCodeLocationDTO(ast.getMetadata()), (Object)model, ast.getType(), params, ast.directChildrenStream().map(comp -> this.toComponentAstDto((ComponentAst)comp, dependencies)).collect(Collectors.toList()));
    }

    protected org.mule.tooling.client.api.extension.model.ParameterizedModel resolveModel(ComponentAst ast, ExtensionModel extension) {
        if (ast.getModel(ConfigurationModel.class).isPresent()) {
            return (org.mule.tooling.client.api.extension.model.ParameterizedModel)ast.getModel(ConfigurationModel.class).flatMap(model -> extension.getConfigurationModel(model.getName())).get();
        }
        if (ast.getModel(ConnectionProviderModel.class).isPresent()) {
            return (org.mule.tooling.client.api.extension.model.ParameterizedModel)ast.getModel(ConnectionProviderModel.class).flatMap(model -> Stream.concat(extension.getConnectionProviders().stream(), extension.getConfigurationModels().stream().flatMap(cfgModel -> cfgModel.getConnectionProviders().stream())).filter(connModel -> connModel.getName().equals(model.getName())).findAny()).get();
        }
        if (ast.getModel(ConstructModel.class).isPresent()) {
            return (org.mule.tooling.client.api.extension.model.ParameterizedModel)ast.getModel(ConstructModel.class).flatMap(model -> extension.getConstructModel(model.getName())).get();
        }
        if (ast.getModel(OperationModel.class).isPresent()) {
            return (org.mule.tooling.client.api.extension.model.ParameterizedModel)ast.getModel(OperationModel.class).flatMap(model -> Stream.concat(extension.getOperationModels().stream(), extension.getConfigurationModels().stream().flatMap(cfgModel -> cfgModel.getOperationModels().stream())).filter(opModel -> opModel.getName().equals(model.getName())).findAny()).get();
        }
        if (ast.getModel(SourceModel.class).isPresent()) {
            return (org.mule.tooling.client.api.extension.model.ParameterizedModel)ast.getModel(SourceModel.class).flatMap(model -> Stream.concat(extension.getSourceModels().stream(), extension.getConfigurationModels().stream().flatMap(cfgModel -> cfgModel.getSourceModels().stream())).filter(srcModel -> srcModel.getName().equals(model.getName())).findAny()).get();
        }
        return null;
    }

    private org.mule.tooling.client.api.artifact.ast.ComponentParameterAst toComponentParameterAstDto(org.mule.tooling.client.api.extension.model.ParameterizedModel owner, ComponentParameterAst ast, Map<String, ExtensionModel> dependencies) {
        Either valueDto = ast.getValue().mapRight(r -> {
            if (r instanceof ComponentAst) {
                return this.toComponentAstDto((ComponentAst)r, dependencies);
            }
            return r;
        });
        ParameterModel paramModel = owner.getAllParameterModels().stream().filter(pm -> pm.getName().equals(ast.getModel().getName())).findFirst().orElse(null);
        return new org.mule.tooling.client.api.artifact.ast.ComponentParameterAst(paramModel, Optional.ofNullable((String)valueDto.getLeft()), Optional.ofNullable(valueDto.getRight()), ast.getRawValue(), ast.getResolvedRawValue(), (SourceCodeLocation)ast.getMetadata().map(ComponentLocationFactory::toSourceCodeLocationDTO).orElse(null), new ComponentGenerationInformation((DslElementSyntax)ast.getGenerationInformation().getSyntax().map(stx -> DefaultDslSyntaxResolverService.toDslDto(stx)).orElse(null)), ast.isDefaultValue());
    }

    protected ArtifactAst getAst() {
        return this.artifact.getApplicationModel().getMuleApplicationModel();
    }

    public void dispose() {
        this.artifact.dispose();
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "id": {
                return this.serializer.serialize((Object)this.getId());
            }
            case "getParent": {
                return this.getParent();
            }
            case "connectivityTestingService": {
                return this.connectivityTestingService();
            }
            case "metadataService": {
                return this.metadataService();
            }
            case "dataSenseService": {
                return this.dataSenseService();
            }
            case "dataWeaveService": {
                return this.dataWeaveService();
            }
            case "valueProviderService": {
                return this.valueProviderService();
            }
            case "sampleDataService": {
                return this.sampleDataService();
            }
            case "getResourceLoader": {
                return this.getResourceLoader();
            }
            case "componentLocationService": {
                return this.componentLocationService();
            }
            case "getArtifactAst": {
                return this.serializer.serialize((Object)this.getArtifactAst());
            }
            case "dispose": {
                this.dispose();
                return null;
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

