/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class JarUtils {
    private static final String EXTRACTED_JAR_PREFIX = "extractedJar-";

    public Optional<File> decompressJarFile(File jarFile) throws IOException {
        Optional<File> decompressedFileOptional;
        File extractedJar = Files.createTempDirectory(EXTRACTED_JAR_PREFIX, new FileAttribute[0]).toFile();
        try (JarArchiveInputStream jarArchiveInputStream = new JarArchiveInputStream(Files.newInputStream(jarFile.toPath(), new OpenOption[0]));){
            JarArchiveEntry jarArchiveEntry;
            while ((jarArchiveEntry = jarArchiveInputStream.getNextJarEntry()) != null) {
                if (jarArchiveEntry.isDirectory()) continue;
                File currentFile = new File(extractedJar, jarArchiveEntry.getName());
                File parent = currentFile.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("could not create directory: " + parent.getPath());
                }
                IOUtils.copy((InputStream)jarArchiveInputStream, (OutputStream)new FileOutputStream(currentFile));
            }
            decompressedFileOptional = Optional.of(extractedJar);
        }
        return decompressedFileOptional;
    }
}

