/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;
import org.mule.runtime.config.api.dsl.model.metadata.DeclarationBasedMetadataCacheIdGenerator;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.api.sampledata.SampleDataMessageModelFailure;
import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;
import org.mule.tooling.client.api.cache.CacheStorage;
import org.mule.tooling.client.api.cache.CacheStorageSerializer;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.declaration.session.DeclarationSession;
import org.mule.tooling.client.api.declaration.session.DeclarationSessionCacheService;
import org.mule.tooling.client.api.descriptors.dependency.Dependency;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataFailure;
import org.mule.tooling.client.api.sampledata.ComponentSampleDataFailure;
import org.mule.tooling.client.api.sampledata.ComponentSampleDataResult;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.cache.DefaultCacheStorageSerializer;
import org.mule.tooling.client.internal.metadata.DeclarationToolingMetadataCacheIdGenerator;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.session.ConfigurationDeclarationProvider;
import org.mule.tooling.client.internal.session.DeclarationSessionComponentLocator;
import org.mule.tooling.client.internal.session.DeclarationSessionConfig;
import org.mule.tooling.client.internal.session.DefaultDeclarationSessionCacheService;
import org.mule.tooling.client.internal.session.ExtensionModelProvider;
import org.mule.tooling.client.internal.session.RemoteSessionExecutor;
import org.mule.tooling.client.internal.session.cache.DeclarationMetadataCache;
import org.mule.tooling.client.internal.session.cache.DeclarationValueProviderCache;
import org.mule.tooling.client.internal.session.cache.DefaultDeclarationMetadataCache;
import org.mule.tooling.client.internal.session.cache.DefaultDeclarationValueProviderCache;
import org.mule.tooling.client.internal.session.cache.MDCMapDecorator;
import org.mule.tooling.client.internal.session.cache.NoOpDeclarationCache;
import org.mule.tooling.client.internal.session.factory.RemoteDeclarationSessionProvider;
import org.mule.tooling.client.internal.session.filter.FieldValueFilter;
import org.mule.tooling.client.internal.session.filter.MetadataKeyFilter;
import org.mule.tooling.client.internal.session.filter.ValueFilter;
import org.mule.tooling.client.internal.session.mediator.FieldValuesResolverModelMediator;
import org.mule.tooling.client.internal.session.mediator.ValuesResolverModelMediator;
import org.mule.tooling.client.internal.session.mediator.resolver.ValuesResolverFactory;
import org.mule.tooling.client.internal.session.validation.ComponentMetadataKeyValidator;
import org.mule.tooling.client.internal.session.validation.ConnectionAndConfigurationValidator;
import org.mule.tooling.client.internal.session.validation.SampleDataActingParametersValidator;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.SessionCallValidator;
import org.mule.tooling.client.internal.session.validation.Validators;
import org.mule.tooling.client.internal.utils.MetadataTypesUtils;
import org.mule.tooling.client.internal.utils.SampleDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeclarationSession
implements DeclarationSession,
Command {
    private static final Map<String, FailureCode> FAILURE_CODES = ImmutableMap.of((Object)org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_CONFIGURATION.getName(), (Object)FailureCode.invalidConfigurationFailureCode((String)org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_CONFIGURATION.getName()), (Object)"INVALID_ELEMENT", (Object)FailureCode.componentNotFoundFailureCode((String)"INVALID_ELEMENT"), (Object)org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_METADATA_KEY.getName(), (Object)FailureCode.invalidMetadataKeyFailureCode((String)org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_METADATA_KEY.getName()));
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RemoteDeclarationSessionProvider remoteDeclarationSessionProvider;
    private final RemoteSessionExecutor remoteSessionExecutor;
    private final Serializer serializer;
    private final RuntimeToolingService runtimeToolingService;
    private final DeclarationSessionCacheService cacheService;
    private final ConfigurationDeclarationProvider configDeclarationProvider;
    private final DeclarationValueProviderCache valueProviderCache;
    private final DeclarationMetadataCache metadataCache;
    private final SessionCallValidator callValidator;
    private final ValuesResolverFactory valuesResolverFactory;

    private DefaultDeclarationSession(RemoteDeclarationSessionProvider remoteDeclarationSessionProvider, Serializer serializer, ExtensionModelProvider extensionModelProvider, ConfigurationDeclarationProvider configurationDeclarationProvider, RuntimeToolingService runtimeToolingService, DeclarationValueProviderCache valueProviderCache, DeclarationMetadataCache metadataCache, DeclarationSessionCacheService cacheService, ExpressionLanguage expressionLanguage) {
        Objects.requireNonNull(remoteDeclarationSessionProvider, "remoteDeclarationSessionProvider info cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        Objects.requireNonNull(extensionModelProvider, "extensionModelProvider cannot be null");
        Objects.requireNonNull(configurationDeclarationProvider, "configurationElementDeclaration cannot be null");
        Objects.requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");
        Objects.requireNonNull(valueProviderCache, "valueProviderCache cannot be null");
        Objects.requireNonNull(metadataCache, "metadataCache cannot be null");
        Objects.requireNonNull(cacheService, "cacheService cannot be null");
        Objects.requireNonNull(expressionLanguage, "expressionLanguage cannot be null");
        this.remoteDeclarationSessionProvider = remoteDeclarationSessionProvider;
        this.remoteSessionExecutor = new RemoteSessionExecutor(remoteDeclarationSessionProvider);
        this.serializer = serializer;
        this.configDeclarationProvider = configurationDeclarationProvider;
        this.runtimeToolingService = runtimeToolingService;
        this.valueProviderCache = valueProviderCache;
        this.metadataCache = metadataCache;
        this.cacheService = cacheService;
        this.callValidator = new SessionCallValidator(extensionModelProvider, configurationDeclarationProvider);
        this.valuesResolverFactory = new ValuesResolverFactory(this.remoteSessionExecutor, runtimeToolingService, valueProviderCache, metadataCache, new ValueFilter(), new MetadataKeyFilter(), new FieldValueFilter(expressionLanguage));
    }

    public ConnectionValidationResult testConnection(String configName) {
        try {
            this.callValidator.validateConfig(configName, c -> {
                if (c.getConfigurationModel().getConnectionProviders().isEmpty() && c.getExtensionModel().getConnectionProviders().isEmpty()) {
                    throw new SessionCallValidationException(String.format("Referenced config: '%s' can't have a connection provider", c.getConfigDeclaration().getRefName()), "No connection provider in config", "INVALID_ELEMENT");
                }
                if (!c.getConfigDeclaration().getConnection().isPresent()) {
                    throw new SessionCallValidationException(String.format("The referenced config: '%s' does not have a connection defined", c.getConfigDeclaration().getRefName()), "No connection in config", "MISSING_REQUIRED_PARAMETERS");
                }
            });
        }
        catch (SessionCallValidationException e2) {
            ConnectionValidationResult connectionValidationResult = new ConnectionValidationResult();
            connectionValidationResult.setValid(false);
            connectionValidationResult.setMessage(e2.getMessage());
            connectionValidationResult.setException(ExceptionUtils.getStackTrace((Throwable)e2));
            return connectionValidationResult;
        }
        return this.remoteSessionExecutor.withRemoteDeclarationSession(id -> this.runtimeToolingService.testConnection(id, configName), e -> {
            ConnectionValidationResult connectionValidationResult = new ConnectionValidationResult();
            connectionValidationResult.setValid(false);
            connectionValidationResult.setMessage(e.getMessage());
            connectionValidationResult.setException(ExceptionUtils.getStackTrace((Throwable)e));
            return connectionValidationResult;
        });
    }

    public ValueResolverResult getValues(ParameterizedElementDeclaration elementDeclaration, String parameterName, boolean ignoreCache) {
        this.logger.info("Resolving values for parameter: '{}' on element: '{}' for declared for extension: '{}'", new Object[]{parameterName, elementDeclaration.getName(), elementDeclaration.getDeclaringExtension()});
        return new ValuesResolverModelMediator(this.configDeclarationProvider, elementDeclaration, this.callValidator, parameterName).resolve(this.valuesResolverFactory, ignoreCache);
    }

    public ValueResolverResult getFieldValues(ParameterizedElementDeclaration elementDeclaration, String parameterName, String targetSelector, boolean ignoreCache) {
        this.logger.info("Resolving values for parameter: '{}' for targetSelector '{}' on element: '{}' for declared for extension: '{}'", new Object[]{parameterName, targetSelector, elementDeclaration.getName(), elementDeclaration.getDeclaringExtension()});
        return new FieldValuesResolverModelMediator(this.configDeclarationProvider, elementDeclaration, this.callValidator, parameterName, targetSelector).resolve(this.valuesResolverFactory, ignoreCache);
    }

    public org.mule.tooling.client.api.metadata.MetadataResult<org.mule.tooling.client.api.metadata.ComponentMetadataTypesDescriptor> resolveComponentMetadata(ComponentElementDeclaration componentElementDeclaration, boolean ignoreCache) {
        try {
            Reference requiresConnection = new Reference((Object)false);
            Reference requiresConfiguration = new Reference((Object)false);
            Validators.ComponentValidator[] componentValidatorArray = new Validators.ComponentValidator[3];
            componentValidatorArray[0] = c -> c.getEnrichableModel().getModelProperty(TypeResolversInformationModelProperty.class).ifPresent(mp -> {
                requiresConnection.set((Object)MetadataTypesUtils.requiresConnection(c.getParameterizedModel(), mp));
                requiresConfiguration.set((Object)MetadataTypesUtils.requiresConfiguration(c.getParameterizedModel(), mp));
            });
            componentValidatorArray[1] = new ConnectionAndConfigurationValidator((ParameterizedElementDeclaration)componentElementDeclaration, this.configDeclarationProvider, () -> ((Reference)requiresConnection).get(), () -> ((Reference)requiresConfiguration).get(), () -> String.format("Type resolver on element: '%s' for extension: '%s'", componentElementDeclaration.getName(), componentElementDeclaration.getDeclaringExtension()));
            componentValidatorArray[2] = new ComponentMetadataKeyValidator(componentElementDeclaration);
            this.callValidator.validateComponent((ParameterizedElementDeclaration)componentElementDeclaration, componentValidatorArray);
        }
        catch (SessionCallValidationException e) {
            return org.mule.tooling.client.api.metadata.MetadataResult.failure((org.mule.tooling.client.api.metadata.MetadataFailure[])new org.mule.tooling.client.api.metadata.MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(e.getMessage()).withReason(e.getReason()).withFailureCode(FAILURE_CODES.getOrDefault(e.getFailureCode(), FailureCode.noneFailureCode((String)org.mule.runtime.api.metadata.resolving.FailureCode.UNKNOWN.getName()))).onComponent()});
        }
        MetadataResult<ComponentMetadataTypesDescriptor> componentMetadataTypesMetadataResult = this.metadataCache.getComponentMetadata(componentElementDeclaration, () -> this.remoteSessionExecutor.withRemoteDeclarationSession(id -> this.runtimeToolingService.getComponentMetadata(id, componentElementDeclaration, ignoreCache), e -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()})), ignoreCache);
        return MetadataPartsFactory.toMetadataResultDTO(componentMetadataTypesMetadataResult, () -> MetadataPartsFactory.toComponentMetadataTypesDescriptorDTO((ComponentMetadataTypesDescriptor)componentMetadataTypesMetadataResult.get()));
    }

    public ComponentSampleDataResult getSampleData(ComponentElementDeclaration componentElementDeclaration) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving sample data on element: '{}' declared for extension: '{}'", (Object)componentElementDeclaration.getName(), (Object)componentElementDeclaration.getDeclaringExtension());
        }
        Reference requiresConfig = new Reference((Object)false);
        Reference requiresConnection = new Reference((Object)false);
        try {
            Validators.ComponentValidator[] componentValidatorArray = new Validators.ComponentValidator[3];
            componentValidatorArray[0] = c -> c.getComponentModel().filter(cm -> cm instanceof HasOutputModel).map(cm -> (HasOutputModel)cm).flatMap(HasOutputModel::getSampleDataProviderModel).ifPresent(sampleDataProviderModel -> {
                requiresConfig.set((Object)sampleDataProviderModel.requiresConfiguration());
                requiresConnection.set((Object)sampleDataProviderModel.requiresConnection());
            });
            componentValidatorArray[1] = new SampleDataActingParametersValidator();
            componentValidatorArray[2] = new ConnectionAndConfigurationValidator((ParameterizedElementDeclaration)componentElementDeclaration, this.configDeclarationProvider, () -> ((Reference)requiresConnection).get(), () -> ((Reference)requiresConfig).get(), () -> String.format("SampleData on element: '%s' for extension: '%s'", componentElementDeclaration.getName(), componentElementDeclaration.getDeclaringExtension()));
            this.callValidator.validateComponent((ParameterizedElementDeclaration)componentElementDeclaration, componentValidatorArray);
        }
        catch (SessionCallValidationException e2) {
            return new ComponentSampleDataResult(new ComponentSampleDataFailure(e2.getMessage(), e2.getReason(), e2.getFailureCode()));
        }
        SampleDataMessageModelResult sampleDataMessageModelResult = this.remoteSessionExecutor.withRemoteDeclarationSession(id -> this.runtimeToolingService.getSampleData(id, componentElementDeclaration), e -> new SampleDataMessageModelResult(new SampleDataMessageModelFailure(e)));
        return SampleDataUtils.toComponentSampleDataResult(sampleDataMessageModelResult);
    }

    public DeclarationSessionCacheService getCacheService() {
        return this.cacheService;
    }

    public void dispose() {
        if (this.remoteDeclarationSessionProvider.isDeployed()) {
            this.remoteSessionExecutor.withRemoteDeclarationSession(id -> {
                this.runtimeToolingService.disposeDeclarationSession(id);
                return null;
            }, e -> null);
        }
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getFieldValues": {
                this.validateInput(arguments, classes, new Class[]{ParameterizedElementDeclaration.class, String.class, String.class, Boolean.class});
                ParameterizedElementDeclaration elementDeclaration = (ParameterizedElementDeclaration)this.serializer.deserialize(arguments[0]);
                String parameterName = (String)this.serializer.deserialize(arguments[1]);
                String targetSelector = (String)this.serializer.deserialize(arguments[2]);
                boolean ignoreCache = (Boolean)this.serializer.deserialize(arguments[3]);
                return this.serializer.serialize((Object)this.getFieldValues(elementDeclaration, parameterName, targetSelector, ignoreCache));
            }
            case "getValues": {
                this.validateInput(arguments, classes, new Class[]{ParameterizedElementDeclaration.class, String.class, Boolean.class});
                ParameterizedElementDeclaration elementDeclaration = (ParameterizedElementDeclaration)this.serializer.deserialize(arguments[0]);
                String parameterName = (String)this.serializer.deserialize(arguments[1]);
                boolean ignoreCache = (Boolean)this.serializer.deserialize(arguments[2]);
                return this.serializer.serialize((Object)this.getValues(elementDeclaration, parameterName, ignoreCache));
            }
            case "resolveComponentMetadata": {
                this.validateInput(arguments, classes, new Class[]{ComponentElementDeclaration.class, Boolean.class});
                ComponentElementDeclaration componentElementDeclaration = (ComponentElementDeclaration)this.serializer.deserialize(arguments[0]);
                boolean ignoreCache = (Boolean)this.serializer.deserialize(arguments[1]);
                return this.serializer.serialize(this.resolveComponentMetadata(componentElementDeclaration, ignoreCache));
            }
            case "getSampleData": {
                this.validateInput(arguments, classes, new Class[]{ComponentElementDeclaration.class});
                ComponentElementDeclaration componentElementDeclaration = (ComponentElementDeclaration)this.serializer.deserialize(arguments[0]);
                return this.serializer.serialize((Object)this.getSampleData(componentElementDeclaration));
            }
            case "testConnection": {
                this.validateInput(arguments, classes, new Class[]{String.class});
                String configName = (String)this.serializer.deserialize(arguments[0]);
                return this.serializer.serialize((Object)this.testConnection(configName));
            }
            case "getCacheService": {
                return this.getCacheService();
            }
            case "dispose": {
                this.dispose();
                return null;
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }

    public static class DefaultDeclarationSessionBuilder
    implements DeclarationSession.Builder,
    Command {
        private Serializer serializer;
        private RuntimeToolingService runtimeToolingService;
        private List<ConfigurationElementDeclaration> configurationElementDeclarations = new ArrayList<ConfigurationElementDeclaration>();
        private List<TopLevelParameterDeclaration> globalParameterDeclarations = new ArrayList<TopLevelParameterDeclaration>();
        private List<Dependency> dependencies = new ArrayList<Dependency>();
        private Map<String, String> sessionProperties = Collections.emptyMap();
        private MavenClient mavenClient;
        private MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
        private Map<String, ?> cacheStorage;
        private ExpressionLanguage expressionLanguage;

        public DefaultDeclarationSessionBuilder(Serializer serializer, RuntimeToolingService runtimeToolingService, MavenClient mavenClient, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, ExpressionLanguage expressionLanguage) {
            this.serializer = serializer;
            this.runtimeToolingService = runtimeToolingService;
            this.mavenClient = mavenClient;
            this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
            this.expressionLanguage = expressionLanguage;
        }

        public DeclarationSession.Builder withConfigurationElementDeclarations(List<ConfigurationElementDeclaration> configurationElementDeclarations) {
            Objects.requireNonNull(configurationElementDeclarations, "configurationElementDeclarations cannot be null");
            this.configurationElementDeclarations.addAll(configurationElementDeclarations);
            return this;
        }

        public DeclarationSession.Builder withGlobalParameters(List<TopLevelParameterDeclaration> globalParameterDeclarations) {
            Objects.requireNonNull(globalParameterDeclarations, "globalParameterDeclarations cannot be null");
            this.globalParameterDeclarations.addAll(globalParameterDeclarations);
            return this;
        }

        public DeclarationSession.Builder withSessionProperties(Map<String, String> sessionProperties) {
            this.sessionProperties = sessionProperties;
            return this;
        }

        public DeclarationSession.Builder withDependency(Dependency dependency) {
            Objects.requireNonNull(dependency, "dependency cannot be null");
            this.dependencies.add(dependency);
            return this;
        }

        public DeclarationSession.Builder withCacheStorage(CacheStorage cacheStorage) {
            throw new UnsupportedOperationException("Calling withCacheStorage on tooling client is not allowed. It must be called through the API.");
        }

        public DeclarationSession.Builder internalWithCacheStorage(Map<String, ?> cacheStorage) {
            Objects.requireNonNull(cacheStorage, "Cache storage cannot be null");
            this.cacheStorage = new MDCMapDecorator(cacheStorage);
            return this;
        }

        public DeclarationSession build() {
            DeclarationSessionConfig declarationSessionConfig = new DeclarationSessionConfig(this.configurationElementDeclarations, this.globalParameterDeclarations, this.dependencies, this.sessionProperties);
            ExtensionModelProvider extensionModelProvider = new ExtensionModelProvider(this.mavenClient, this.muleRuntimeExtensionModelProvider, this.dependencies);
            ConfigurationDeclarationProvider configurationDeclarationProvider = new ConfigurationDeclarationProvider(this.configurationElementDeclarations);
            DeclarationToolingMetadataCacheIdGenerator cacheIdGenerator = null;
            DeclarationSessionComponentLocator sessionLocator = null;
            DeclarationValueProviderCache valueProviderCache = NoOpDeclarationCache.noOpDeclarationCache();
            DeclarationMetadataCache metadataCache = NoOpDeclarationCache.noOpDeclarationCache();
            if (this.cacheStorage != null) {
                DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(extensionModelProvider.getAll());
                sessionLocator = new DeclarationSessionComponentLocator(this.configurationElementDeclarations, this.globalParameterDeclarations);
                cacheIdGenerator = new DeclarationToolingMetadataCacheIdGenerator((MetadataCacheIdGenerator<ElementDeclaration>)new DeclarationBasedMetadataCacheIdGenerator(dslResolvingContext, (ComponentLocator)sessionLocator), new DeclarationToolingMetadataCacheIdGenerator.DeclarationBasedValueProviderCacheIdGeneratorAdapter(dslResolvingContext, sessionLocator));
                valueProviderCache = new DefaultDeclarationValueProviderCache(cacheIdGenerator, this.cacheStorage);
                metadataCache = new DefaultDeclarationMetadataCache(cacheIdGenerator, this.cacheStorage, this.cacheStorage, extensionModelProvider);
            }
            return new DefaultDeclarationSession(new RemoteDeclarationSessionProvider(extensionModelProvider, this.runtimeToolingService, declarationSessionConfig), this.serializer, extensionModelProvider, configurationDeclarationProvider, this.runtimeToolingService, valueProviderCache, metadataCache, new DefaultDeclarationSessionCacheService((CacheStorageSerializer)new DefaultCacheStorageSerializer(), this.serializer, cacheIdGenerator, this.cacheStorage, sessionLocator), this.expressionLanguage);
        }

        @Override
        public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
            switch (methodName) {
                case "withConfigurationElementDeclarations": {
                    this.validateInput(arguments, classes, new Class[]{List.class});
                    List configurationElementDeclarations = (List)this.serializer.deserialize(arguments[0]);
                    return this.withConfigurationElementDeclarations(configurationElementDeclarations);
                }
                case "withGlobalParameters": {
                    this.validateInput(arguments, classes, new Class[]{List.class});
                    List globalParameterDeclarations = (List)this.serializer.deserialize(arguments[0]);
                    return this.withGlobalParameters(globalParameterDeclarations);
                }
                case "withSessionProperties": {
                    this.validateInput(arguments, classes, new Class[]{Map.class});
                    Map sessionProperties = (Map)this.serializer.deserialize(arguments[0]);
                    return this.withSessionProperties(sessionProperties);
                }
                case "withDependency": {
                    this.validateInput(arguments, classes, new Class[]{Dependency.class});
                    Dependency dependency = (Dependency)this.serializer.deserialize(arguments[0]);
                    return this.withDependency(dependency);
                }
                case "build": {
                    return this.build();
                }
            }
            throw Command.methodNotFound(this.getClass(), methodName);
        }
    }
}

