/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.icons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.icons.DefaultIconsResult;
import org.mule.tooling.client.api.icons.ExtensionIconsService;
import org.mule.tooling.client.api.icons.IconsResult;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DefaultExtensionIconsService
implements ExtensionIconsService,
Command {
    private MavenClient mavenClient;
    private Serializer serializer;
    private static final String SVG = ".svg";

    public DefaultExtensionIconsService(MavenClient mavenClient, Serializer serializer) {
        this.mavenClient = mavenClient;
        this.serializer = serializer;
    }

    public IconsResult getIconsFor(ArtifactDescriptor artifactDescriptor) {
        DefaultIconsResult defaultIconsResult;
        BundleDependency bundleDependency = this.mavenClient.resolveBundleDescriptor(this.toBundleDescriptor(artifactDescriptor));
        URI bundleUri = bundleDependency.getBundleUri();
        ZipFile file = new ZipFile(new File(bundleUri));
        try {
            Enumeration<? extends ZipEntry> entries = file.entries();
            HashMap<String, byte[]> additionalIcons = new HashMap<String, byte[]>();
            byte[] defaultIcon = null;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String iconPath = entry.getName();
                if (!iconPath.startsWith("META-INF/mule-artifact") || !iconPath.toLowerCase().endsWith(SVG)) continue;
                int i = iconPath.lastIndexOf(47) + 1;
                String iconName = iconPath.substring(i, iconPath.length() - 4);
                if (iconName.equals("icon")) {
                    defaultIcon = IOUtils.toByteArray((InputStream)file.getInputStream(entry));
                    continue;
                }
                additionalIcons.put(iconName, IOUtils.toByteArray((InputStream)file.getInputStream(entry)));
            }
            defaultIconsResult = new DefaultIconsResult(defaultIcon, additionalIcons);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to retrieve icons.", e);
            }
        }
        file.close();
        return defaultIconsResult;
    }

    private BundleDescriptor toBundleDescriptor(ArtifactDescriptor pluginDescriptor) {
        return new BundleDescriptor.Builder().setGroupId(pluginDescriptor.getGroupId()).setArtifactId(pluginDescriptor.getArtifactId()).setVersion(pluginDescriptor.getVersion()).setType(pluginDescriptor.getExtension()).setClassifier(pluginDescriptor.getClassifier()).build();
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        if (methodName.equals("getIconsFor")) {
            Object artifactDescriptor = this.serializer.deserialize(arguments[0]);
            IconsResult iconsResult = this.getIconsFor((ArtifactDescriptor)artifactDescriptor);
            return this.serializer.serialize((Object)iconsResult);
        }
        throw Command.methodNotFound(DefaultExtensionIconsService.class, methodName);
    }
}

