/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.maven.artifact.ArtifactUtils;
import org.json.JSONObject;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelServiceCache
implements Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE = "tooling.client.ExtensionModelServiceCache.maximumSize";
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS = "tooling.client.ExtensionModelServiceCache.expireAfterAccess";
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISKSTORE_PATH = "tooling.client.ExtensionModelServiceCache.diskStore.path";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelServiceCache.class);
    private static final String DEFAULT_MAX_SIZE = "100";
    private static final String MIN_MULE_VERSION = "minMuleVersion";
    private static final String EXTENSION_MODEL = "extensionModel";
    public static final String METADATA_KEY = "metadataKey";
    public static final String METADATA_CACHE_PROPERTIES_FILE_NAME = "metadata-cache.properties";
    private File diskStorePath;
    private List<ExtensionModel> runtimeExtensionModels;
    private Cache<String, Optional<LoadedExtensionInformation>> extensionModelsByArtifact;

    private Integer cacheMaximumSize() {
        Integer cacheSize = Integer.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE, DEFAULT_MAX_SIZE));
        Preconditions.checkArgument((cacheSize > 0 ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, the cache cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE));
        return cacheSize;
    }

    private Optional<Long> cacheExpireAfterAccess() {
        if (System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS) == null) {
            return Optional.empty();
        }
        Long cacheSize = Long.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS));
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, cacheExpireAfterAccess cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE));
        return Optional.of(cacheSize);
    }

    private File diskStorePath() {
        if (System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISKSTORE_PATH) == null) {
            return null;
        }
        File diskStorePath = new File(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISKSTORE_PATH));
        if (!diskStorePath.exists()) {
            boolean created = diskStorePath.mkdirs();
            Preconditions.checkArgument((boolean)created, (String)String.format("Couldn't create folders Extension Model service cache persistent data using path", diskStorePath));
        }
        return diskStorePath;
    }

    public ExtensionModelServiceCache(String toolingVersion) {
        this(toolingVersion, false);
    }

    public ExtensionModelServiceCache(String toolingVersion, boolean recordStats) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initialising Extension Model Service cache");
        }
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue());
        this.cacheExpireAfterAccess().ifPresent(value -> builder.expireAfterAccess(value.longValue(), TimeUnit.SECONDS));
        if (recordStats) {
            builder.recordStats();
        }
        this.diskStorePath = this.diskStorePath();
        if (this.diskStorePath != null) {
            this.diskStorePath = new File(this.diskStorePath, toolingVersion);
            if (!this.diskStorePath.exists()) {
                boolean created = this.diskStorePath.mkdirs();
                Preconditions.checkArgument((boolean)created, (String)String.format("Couldn't create folders Extension Model service cache persistent data using path", this.diskStorePath));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Enabling cache persistence for Extension Model Service on path '{}'", (Object)this.diskStorePath.getAbsolutePath());
            }
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Extension Model Service cache working in memory only");
        }
        this.extensionModelsByArtifact = builder.build();
    }

    public Optional<LoadedExtensionInformation> loadExtensionInformation(BundleDependency bundleDependency, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> (Optional)this.extensionModelsByArtifact.get((Object)this.newCacheKey(bundleDependency), this.generateExtensionModelInformation(bundleDependency, () -> extensionModelService.loadExtensionData(bundleDependency.getDescriptor()))));
    }

    public Set<ExtensionModel> loadExtensionModels(List<ArtifactClassLoader> artifactPluginClassLoaders, InternalExtensionModelService extensionModelService) {
        HashSet extensionModels = Sets.newHashSet();
        for (ArtifactClassLoader artifactClassLoader : artifactPluginClassLoaders) {
            BundleDependency bundleDependency = this.createBundleDependency(artifactClassLoader.getArtifactDescriptor());
            Optional loadedExtensionInformation = ServiceUtils.executeHandlingException(() -> (Optional)this.extensionModelsByArtifact.get((Object)this.newCacheKey(bundleDependency), this.generateExtensionModelInformation(bundleDependency, () -> extensionModelService.loadExtensionData(artifactClassLoader, artifactPluginClassLoaders))));
            loadedExtensionInformation.ifPresent(modelInformation -> extensionModels.add(modelInformation.getExtensionModel()));
        }
        return extensionModels;
    }

    private Callable<Optional<LoadedExtensionInformation>> generateExtensionModelInformation(BundleDependency bundleDependency, Supplier<Optional<LoadedExtensionInformation>> modelLoader) {
        return () -> {
            File pluginFile = this.getBundleDependencyFile(bundleDependency);
            BundleDescriptor bundleDescriptor = bundleDependency.getDescriptor();
            return this.readExtensionModelData(pluginFile, bundleDescriptor).orElseGet(() -> this.lambda$generateExtensionModelInformation$8((Supplier)modelLoader, bundleDependency, bundleDescriptor, pluginFile));
        };
    }

    private Optional<Optional<LoadedExtensionInformation>> readExtensionModelData(File pluginFile, BundleDescriptor bundleDescriptor) {
        block3: {
            if (this.diskStorePath != null && this.existExtensionDataFiles(bundleDescriptor, pluginFile)) {
                try {
                    return Optional.of(this.loadExtensionModelFromDisk(bundleDescriptor, pluginFile));
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Error while loading {} Extension Model from file data, error: '{}'. It will be loaded again from jar file and writing to disk again", (Object)bundleDescriptor, (Object)e.getMessage());
                }
            }
        }
        return Optional.empty();
    }

    private boolean existExtensionDataFiles(BundleDescriptor bundleDescriptor, File pluginFile) {
        return this.getExtensionModelPersistenceFile(bundleDescriptor, pluginFile).exists() && this.getExtensionSchemaPersistenceFile(bundleDescriptor, pluginFile).exists();
    }

    private String newCacheKey(BundleDependency bundleDependency) {
        return this.getPathForBundleDescriptor(bundleDependency.getDescriptor(), this.getBundleDependencyFile(bundleDependency), Optional.empty());
    }

    private File getBundleDependencyFile(BundleDependency bundleDependency) {
        try {
            return FileUtils.toFile((URL)bundleDependency.getBundleUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Error while getting artifact file for %s", bundleDependency), e);
        }
    }

    private Optional<LoadedExtensionInformation> loadExtensionModelFromDisk(BundleDescriptor bundleDescriptor, File pluginFile) {
        long startTime = System.nanoTime();
        try {
            File extensionModelFile = this.getExtensionModelPersistenceFile(bundleDescriptor, pluginFile);
            String content = FileUtils.readFileToString((File)extensionModelFile, (Charset)Charset.defaultCharset());
            JSONObject jsonObject = new JSONObject(content);
            if (jsonObject.length() != 0) {
                if (jsonObject.has(MIN_MULE_VERSION) && jsonObject.has(EXTENSION_MODEL)) {
                    ExtensionModel extensionModel = new ExtensionModelJsonSerializer().deserialize(jsonObject.get(EXTENSION_MODEL).toString());
                    Optional<LoadedExtensionInformation> optional = Optional.of(new LoadedExtensionInformation(extensionModel, (LazyValue<String>)new LazyValue(() -> {
                        File schemaFile = this.getExtensionSchemaPersistenceFile(bundleDescriptor, pluginFile);
                        if (!schemaFile.exists()) {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info("No schema file found from disk cache for {}", (Object)bundleDescriptor);
                            }
                            return "";
                        }
                        try {
                            return FileUtils.readFileToString((File)schemaFile, (Charset)Charset.defaultCharset());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }), jsonObject.getString(MIN_MULE_VERSION)));
                    return optional;
                }
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Ignoring file for {} as its content is invalid", (Object)bundleDescriptor);
                }
            }
            Optional<LoadedExtensionInformation> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Extension model for {} loaded from file disk in {}ms", (Object)bundleDescriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
        }
    }

    private List<String> collectPreviousKeys(BundleDescriptor bundleDescriptor, File pluginFile) {
        File[] directories;
        if (!ArtifactUtils.isSnapshot((String)bundleDescriptor.getVersion())) {
            return Collections.emptyList();
        }
        ArrayList keysToBeInvalidated = Lists.newArrayList();
        IOFileFilter filter = DirectoryFileFilter.INSTANCE;
        if (!bundleDescriptor.getVersion().equals(bundleDescriptor.getBaseVersion())) {
            filter = new AndFileFilter(filter, (IOFileFilter)new NotFileFilter((IOFileFilter)new NameFileFilter(bundleDescriptor.getVersion())));
        }
        if ((directories = this.getExtensionModelPersistenceFile(bundleDescriptor, pluginFile).getParentFile().getParentFile().listFiles((FilenameFilter)filter)) != null) {
            for (File directory : directories) {
                keysToBeInvalidated.add(this.readCacheMetadata(directory).getProperty(METADATA_KEY));
            }
        }
        return keysToBeInvalidated;
    }

    private Properties readCacheMetadata(File directory) {
        Properties properties;
        FileInputStream inputStream = new FileInputStream(new File(directory, METADATA_CACHE_PROPERTIES_FILE_NAME));
        try {
            properties = PropertiesUtils.loadProperties((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Error while reading cache entry metadata from %s", directory), e);
            }
        }
        ((InputStream)inputStream).close();
        return properties;
    }

    private void writeCacheMetadata(BundleDescriptor bundleDescriptor, File directory, Properties content) {
        block10: {
            if (!ArtifactUtils.isSnapshot((String)bundleDescriptor.getVersion())) {
                return;
            }
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File cacheMetadataFile = new File(directory, METADATA_CACHE_PROPERTIES_FILE_NAME);
            try (FileOutputStream outputStream = new FileOutputStream(cacheMetadataFile, false);){
                content.store(outputStream, "Writing metadata file for cache entry");
            }
            catch (IOException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(String.format("Couldn't write to disk Extension Model cache metadata '{}'", cacheMetadataFile.getAbsolutePath()), (Throwable)e);
                }
                if (!cacheMetadataFile.exists()) break block10;
                FileUtils.deleteQuietly((File)cacheMetadataFile);
            }
        }
    }

    private File getExtensionModelPersistenceDirectory(String key) {
        return this.diskStorePath.toPath().resolve(key).toFile();
    }

    private String getExtensionModelPersistenceDirectoryPath(BundleDescriptor bundleDescriptor, File pluginFile) {
        StringBuilder path = new StringBuilder(128);
        path.append(bundleDescriptor.getGroupId().replace('.', '/')).append('/');
        path.append(bundleDescriptor.getArtifactId()).append('/');
        path.append(bundleDescriptor.getVersion());
        if (this.isNormalizedSnapshotVersion(bundleDescriptor)) {
            path.append("-").append(pluginFile.lastModified());
        }
        return path.toString();
    }

    private File getExtensionModelPersistenceFile(BundleDescriptor bundleDescriptor, File pluginFile) {
        return this.diskStorePath.toPath().resolve(this.getPathForBundleDescriptor(bundleDescriptor, pluginFile, Optional.of("json"))).toFile();
    }

    private File getExtensionSchemaPersistenceFile(BundleDescriptor bundleDescriptor, File pluginFile) {
        return this.diskStorePath.toPath().resolve(this.getPathForBundleDescriptor(bundleDescriptor, pluginFile, Optional.of("xsd"))).toFile();
    }

    private void writeExtensionModelToDisk(BundleDescriptor bundleDescriptor, File pluginFile, LoadedExtensionInformation extensionInformation) {
        block5: {
            File extensionModelFile = this.getExtensionModelPersistenceFile(bundleDescriptor, pluginFile);
            File extensionSchemaFile = this.getExtensionSchemaPersistenceFile(bundleDescriptor, pluginFile);
            long startTime = System.nanoTime();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MIN_MULE_VERSION, (Object)extensionInformation.getMinMuleVersion());
            jsonObject.put(EXTENSION_MODEL, (Object)new JSONObject(new ExtensionModelJsonSerializer(false).serialize(extensionInformation.getExtensionModel())));
            try {
                FileUtils.writeStringToFile((File)extensionModelFile, (String)jsonObject.toString(2), (Charset)Charset.defaultCharset(), (boolean)false);
                FileUtils.writeStringToFile((File)extensionSchemaFile, (String)((String)extensionInformation.getSchema().get()), (Charset)Charset.defaultCharset(), (boolean)false);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Extension model data for {} written to file disk in {}ms", (Object)bundleDescriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
                }
            }
            catch (IOException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(String.format("Couldn't write to disk data for Extension Model '{}'", bundleDescriptor), (Throwable)e);
                }
                if (extensionModelFile.exists()) {
                    FileUtils.deleteQuietly((File)extensionModelFile);
                }
                if (!extensionSchemaFile.exists()) break block5;
                FileUtils.deleteQuietly((File)extensionSchemaFile);
            }
        }
    }

    private String getPathForBundleDescriptor(BundleDescriptor bundleDescriptor, File pluginFile, Optional<String> extensionOptional) {
        StringBuilder path = new StringBuilder(this.getExtensionModelPersistenceDirectoryPath(bundleDescriptor, pluginFile));
        extensionOptional.ifPresent(extension -> {
            path.append('/');
            path.append(bundleDescriptor.getArtifactId()).append('-');
            path.append(bundleDescriptor.getVersion());
            if (bundleDescriptor.getClassifier().isPresent()) {
                path.append('-').append((String)bundleDescriptor.getClassifier().get());
            }
            path.append('.').append((String)extension);
        });
        return path.toString();
    }

    private boolean isNormalizedSnapshotVersion(BundleDescriptor bundleDescriptor) {
        return ArtifactUtils.isSnapshot((String)bundleDescriptor.getVersion()) && bundleDescriptor.getVersion().equals(bundleDescriptor.getBaseVersion());
    }

    public Optional<LoadedExtensionInformation> loadExtensionInformation(File plugin, InternalExtensionModelService extensionModelService) {
        BundleDescriptor bundleDescriptor = extensionModelService.readBundleDescriptor(plugin);
        return this.loadExtensionInformation(new BundleDependency.Builder().setDescriptor(bundleDescriptor).setBundleUri(plugin.toURI()).build(), extensionModelService);
    }

    public List<ExtensionModel> loadRuntimeExtensionModels(InternalExtensionModelService extensionModelService) {
        if (this.runtimeExtensionModels == null) {
            this.runtimeExtensionModels = extensionModelService.loadRuntimeExtensionModels();
        }
        return this.runtimeExtensionModels;
    }

    public void dispose() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Disposing Extension Model Service cache");
        }
        this.extensionModelsByArtifact.invalidateAll();
    }

    public CacheStats getCacheStats() {
        return this.extensionModelsByArtifact.stats();
    }

    private BundleDependency createBundleDependency(ArtifactDescriptor artifactDescriptor) {
        org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor = artifactDescriptor.getBundleDescriptor();
        try {
            BundleDescriptor.Builder bundleDescriptorBuilder = new BundleDescriptor.Builder();
            bundleDescriptorBuilder.setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId());
            if (bundleDescriptor.getBaseVersion() != null) {
                bundleDescriptorBuilder.setBaseVersion(bundleDescriptor.getBaseVersion());
            }
            bundleDescriptorBuilder.setVersion(bundleDescriptor.getVersion()).setType(bundleDescriptor.getType()).setClassifier((String)bundleDescriptor.getClassifier().orElse(null));
            return new BundleDependency.Builder().setBundleUri(artifactDescriptor.getClassLoaderConfiguration().getUrls()[0].toURI()).setDescriptor(bundleDescriptorBuilder.build()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ Optional lambda$generateExtensionModelInformation$8(Supplier modelLoader, BundleDependency bundleDependency, BundleDescriptor bundleDescriptor, File pluginFile) {
        Optional extensionInformationOptional = (Optional)modelLoader.get();
        extensionInformationOptional.ifPresent(extensionInformation -> {
            if (this.diskStorePath != null) {
                String cacheKey = this.newCacheKey(bundleDependency);
                try {
                    File extensionModelPersistenceDirectory = this.getExtensionModelPersistenceDirectory(cacheKey);
                    this.collectPreviousKeys(bundleDescriptor, pluginFile).stream().forEach(keyToBeInvalidated -> {
                        this.extensionModelsByArtifact.invalidate(keyToBeInvalidated);
                        FileUtils.deleteQuietly((File)this.getExtensionModelPersistenceDirectory((String)keyToBeInvalidated));
                    });
                    Properties content = new Properties();
                    content.setProperty(METADATA_KEY, cacheKey);
                    this.writeCacheMetadata(bundleDescriptor, extensionModelPersistenceDirectory, content);
                    this.writeExtensionModelToDisk(bundleDescriptor, pluginFile, (LoadedExtensionInformation)extensionInformation);
                }
                catch (Exception e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Error while writing {} Extension Model to disk, error: '{}'. Using in-memory cache without persistence for this entry", (Object)bundleDescriptor, (Object)e.getMessage());
                    }
                    FileUtils.deleteQuietly((File)this.getExtensionModelPersistenceDirectory(cacheKey));
                }
            }
        });
        return extensionInformationOptional;
    }
}

