/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.validation;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.IdentifiableElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelperUtils;
import org.mule.tooling.client.internal.session.ConfigurationDeclarationProvider;
import org.mule.tooling.client.internal.session.ExtensionModelProvider;
import org.mule.tooling.client.internal.session.validation.ComponentValidationContext;
import org.mule.tooling.client.internal.session.validation.ConfigValidationContext;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.Validators;

public class SessionCallValidator {
    public static final String INVALID_TARGET_EXTENSION = "INVALID_TARGET_EXTENSION";
    public static final String INVALID_ELEMENT = "INVALID_ELEMENT";
    public static final String INVALID_PARAMETER = "INVALID_PARAMETER";
    private final ExtensionModelProvider extensionModelProvider;
    private final ConfigurationDeclarationProvider configurationDeclarationProvider;

    public SessionCallValidator(ExtensionModelProvider extensionModelProvider, ConfigurationDeclarationProvider configurationDeclarationProvider) {
        this.extensionModelProvider = extensionModelProvider;
        this.configurationDeclarationProvider = configurationDeclarationProvider;
    }

    public void validateConfig(String configRef, Validators.ConfigValidator ... extraValidators) throws SessionCallValidationException {
        Optional<ConfigurationElementDeclaration> configurationElementDeclarationOptional = this.configurationDeclarationProvider.getConfigDeclaration(configRef);
        if (!configurationElementDeclarationOptional.isPresent()) {
            throw new SessionCallValidationException(String.format("Configuration with ref-name: '%s' does not exist in the session", configRef), "Config not found", FailureCode.COMPONENT_NOT_FOUND.getName());
        }
        ConfigurationElementDeclaration configurationElementDeclaration = configurationElementDeclarationOptional.get();
        ExtensionModel extensionModel = this.getExtensionModelOrFail(configurationElementDeclaration.getDeclaringExtension());
        ArtifactHelperUtils.ConfigAwareModel configurationModel = this.configAwareModelOrFail(extensionModel, (ParameterizedElementDeclaration)configurationElementDeclaration);
        ConfigValidationContext context = new ConfigValidationContext(extensionModel, (ConfigurationModel)configurationModel.getModel(), configurationElementDeclaration);
        for (Validators.ConfigValidator customValidator : extraValidators) {
            customValidator.validate(context);
        }
    }

    public void validateComponent(ParameterizedElementDeclaration parameterizedElementDeclaration, Validators.ComponentValidator ... extraValidators) throws SessionCallValidationException {
        ExtensionModel extensionModel = this.getExtensionModelOrFail(parameterizedElementDeclaration.getDeclaringExtension());
        ArtifactHelperUtils.ConfigAwareModel configAwareComponentModel = this.configAwareModelOrFail(extensionModel, parameterizedElementDeclaration);
        ConfigurationModel configurationModel = null;
        ConfigurationElementDeclaration configurationElementDeclaration = null;
        if (configAwareComponentModel.getConfigModel().isPresent() && parameterizedElementDeclaration instanceof ComponentElementDeclaration) {
            Optional<ConfigurationElementDeclaration> configurationElementDeclarationOptional;
            configurationModel = (ConfigurationModel)configAwareComponentModel.getConfigModel().get();
            String configRef = ((ComponentElementDeclaration)parameterizedElementDeclaration).getConfigRef();
            if (!StringUtils.isEmpty((CharSequence)configRef) && (configurationElementDeclarationOptional = this.configurationDeclarationProvider.getConfigDeclaration(configRef)).isPresent()) {
                configurationElementDeclaration = configurationElementDeclarationOptional.get();
                if (!configurationModel.getName().equals(configurationElementDeclaration.getName())) {
                    throw new SessionCallValidationException(String.format("Component with name: '%s' is referencing a config with name: '%s' and it should reference a config with name: '%s'", parameterizedElementDeclaration.getName(), configurationElementDeclaration.getName(), configurationModel.getName()), "Referencing wrong config", FailureCode.INVALID_CONFIGURATION.getName());
                }
            }
        }
        ComponentValidationContext<ParameterizedModel> context = new ComponentValidationContext<ParameterizedModel>(extensionModel, configurationModel, configurationElementDeclaration, parameterizedElementDeclaration, configAwareComponentModel.getModel());
        for (Validators.ComponentValidator customValidator : extraValidators) {
            customValidator.validate(context);
        }
    }

    private ExtensionModel getExtensionModelOrFail(String name) throws SessionCallValidationException {
        return this.extensionModelProvider.get(name).orElseThrow(() -> new SessionCallValidationException(String.format("ElementDeclaration is declaring an extension: '%s' that is not part of the session: '%s'", name, this.extensionModelProvider.getAllNames()), "ExtensionModel not found", INVALID_TARGET_EXTENSION));
    }

    private <T extends ParameterizedModel & EnrichableModel> ArtifactHelperUtils.ConfigAwareModel<T> configAwareModelOrFail(ExtensionModel extensionModel, ParameterizedElementDeclaration declaration) throws SessionCallValidationException {
        Optional caw = ArtifactHelperUtils.findConfigAwareModel((ExtensionModel)extensionModel, (IdentifiableElementDeclaration)declaration);
        if (!caw.isPresent()) {
            throw new SessionCallValidationException(String.format("Model not found for name: '%s' and extension: '%s'", declaration.getName(), declaration.getDeclaringExtension()), "Model not found in extension model", INVALID_ELEMENT);
        }
        return (ArtifactHelperUtils.ConfigAwareModel)caw.get();
    }
}

