/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dsl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.maven.client.api.MavenClient;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverFactory;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.artifact.dsl.request.DslSyntaxResolverFactoryRequest;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.dsl.ServiceDelegatingDslSyntaxResolver;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.utils.ExtensionModelUtils;

public class DefaultDslSyntaxResolverService
implements DslSyntaxResolverService,
Command {
    private final DslSyntaxServiceCache dslSyntaxServiceCache;
    private final MavenClient mavenClient;
    private final MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private final Serializer serializer;

    public DefaultDslSyntaxResolverService(DslSyntaxServiceCache dslSyntaxServiceCache, MavenClient mavenClient, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, Serializer serializer) {
        this.dslSyntaxServiceCache = dslSyntaxServiceCache;
        this.mavenClient = mavenClient;
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
        this.serializer = serializer;
    }

    public DslSyntaxResolverFactory getDslSyntaxResolverFactory(DslSyntaxResolverFactoryRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"The resolution request cannot be null");
        List pluginArtifactDescriptors = request.getPluginArtifactDescriptors();
        Preconditions.checkArgument((pluginArtifactDescriptors != null ? 1 : 0) != 0, (String)"pluginArtifactDescriptors cannot be null");
        DefaultDslSyntaxResolverService delegate = this;
        return new InternalDslSyntaxResolverFactory(delegate, pluginArtifactDescriptors);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getDslSyntaxResolverFactory": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(DslSyntaxResolverFactoryRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.getDslSyntaxResolverFactory((DslSyntaxResolverFactoryRequest)this.serializer.deserialize(arguments[0]));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }

    public void invalidate(List<ArtifactDescriptor> pluginArtifactDescriptors, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel) {
        this.dslSyntaxServiceCache.invalidate(pluginArtifactDescriptors, toolingModel);
    }

    public DslElementSyntax resolve(SourceModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(OperationModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConstructModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConnectionProviderModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConfigurationModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public Set<ObjectType> getSubTypes(ObjectType type, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        DslResolvingContext context = this.dslSyntaxServiceCache.getContext(pluginArtifactDescriptors, this.mavenClient, this.muleRuntimeExtensionModelProvider);
        return context.getTypeCatalog().getSubTypes(type);
    }

    Optional<DslElementSyntax> resolve(MetadataType type, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        DslResolvingContext context = this.dslSyntaxServiceCache.getContext(pluginArtifactDescriptors, this.mavenClient, this.muleRuntimeExtensionModelProvider);
        return this.dslSyntaxServiceCache.getResolver(this.findExtension(toolingModel, context), context).resolve(type).map(DefaultDslSyntaxResolverService::toDslDto);
    }

    private DslElementSyntax doResolve(Function<ExtensionModel, NamedObject> componentProvider, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        DslResolvingContext context = this.dslSyntaxServiceCache.getContext(pluginArtifactDescriptors, this.mavenClient, this.muleRuntimeExtensionModelProvider);
        ExtensionModel extension = this.findExtension(toolingModel, context);
        return DefaultDslSyntaxResolverService.toDslDto(this.dslSyntaxServiceCache.getResolver(extension, context).resolve(componentProvider.apply(extension)));
    }

    private ExtensionModel findExtension(org.mule.tooling.client.api.extension.model.ExtensionModel toolingExtensionModel, DslResolvingContext resolvingContext) {
        return (ExtensionModel)resolvingContext.getExtension(toolingExtensionModel.getName()).orElseThrow(() -> new IllegalArgumentException(String.format("Extension with name [%s] not found in the current context. Available extensions are %s", resolvingContext.getExtensions().stream().map(e -> e.getName()).collect(Collectors.toList()))));
    }

    public static DslElementSyntax toDslDto(org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax origin) {
        ArrayList metadataTypes = new ArrayList();
        ArrayList dslElementsSyntax = new ArrayList();
        origin.getGenerics().entrySet().stream().forEach(entry -> {
            metadataTypes.add((MetadataType)entry.getKey());
            dslElementsSyntax.add(DefaultDslSyntaxResolverService.toDslDto((org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax)entry.getValue()));
        });
        return new DslElementSyntax(origin.getAttributeName(), origin.getElementName(), origin.getPrefix(), origin.getNamespace(), origin.isWrapped(), origin.supportsAttributeDeclaration(), origin.supportsChildDeclaration(), origin.supportsTopLevelDeclaration(), origin.requiresConfig(), metadataTypes, dslElementsSyntax, origin.getContainedElementsByName().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> DefaultDslSyntaxResolverService.toDslDto((org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax)e.getValue()))));
    }

    private class InternalDslSyntaxResolverFactory
    implements DslSyntaxResolverFactory,
    Command {
        private final DefaultDslSyntaxResolverService delegate;
        private final List<ArtifactDescriptor> pluginArtifactDescriptors;

        public InternalDslSyntaxResolverFactory(DefaultDslSyntaxResolverService delegate, List<ArtifactDescriptor> pluginArtifactDescriptors) {
            this.delegate = delegate;
            this.pluginArtifactDescriptors = pluginArtifactDescriptors;
        }

        public DslSyntaxResolver createDslResolver(org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel) {
            return new ServiceDelegatingDslSyntaxResolver(this.delegate, toolingModel, this.pluginArtifactDescriptors, DefaultDslSyntaxResolverService.this.serializer);
        }

        public void dispose() {
            DefaultDslSyntaxResolverService.this.dslSyntaxServiceCache.invalidate(this.pluginArtifactDescriptors);
        }

        @Override
        public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
            switch (methodName) {
                case "createDslResolver": {
                    Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 1 && classes[0].equals(org.mule.tooling.client.api.extension.model.ExtensionModel.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    return this.createDslResolver((org.mule.tooling.client.api.extension.model.ExtensionModel)DefaultDslSyntaxResolverService.this.serializer.deserialize(arguments[0]));
                }
                case "dispose": {
                    this.dispose();
                    return null;
                }
            }
            throw Command.methodNotFound(this.getClass(), methodName);
        }
    }
}

