/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingApplicationModel {
    private static final String TOOLING_CLIENT_ALLOW_ACCESS_EXTERNAL_RESOURCES = "tooling.client.configuration.allowAccessExternalResources";
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolingApplicationModel.class);
    private final ToolingApplicationModel parent;
    private final ArtifactAst muleApplicationModel;
    private final ConfigurationProperties configurationProperties;
    private final ClassLoader classLoader;

    public ToolingApplicationModel(ToolingApplicationModel parent, ArtifactAst muleApplicationModel, ConfigurationProperties configurationProperties, ClassLoader classLoader) {
        Objects.requireNonNull(muleApplicationModel, "muleApplicationModel cannot be null");
        this.parent = parent;
        this.muleApplicationModel = muleApplicationModel;
        this.configurationProperties = configurationProperties;
        this.classLoader = classLoader;
    }

    public Optional<ToolingApplicationModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ArtifactAst getMuleApplicationModel() {
        return this.muleApplicationModel;
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public Optional<URI> findResource(String resource) {
        URI uri = URI.create(resource);
        if (uri.getScheme() == null) {
            return this.getResourceFromClassLoader(uri.getPath());
        }
        if (uri.getScheme().equalsIgnoreCase("resource")) {
            return this.getResourceFromClassLoader(resource);
        }
        if (Boolean.valueOf(System.getProperty(TOOLING_CLIENT_ALLOW_ACCESS_EXTERNAL_RESOURCES, "false")).booleanValue()) {
            return Optional.of(uri);
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Trying to access an external resources '{}' when Tooling Client is not enabled to access external resources, use the system properties '{}' to enable it ", (Object)resource, (Object)TOOLING_CLIENT_ALLOW_ACCESS_EXTERNAL_RESOURCES);
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<URI> getResourceFromClassLoader(String resource) {
        try {
            URL classLoaderResource = this.classLoader.getResource(resource);
            if (classLoaderResource != null) {
                return Optional.ofNullable(classLoaderResource.toURI());
            }
            return Optional.empty();
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.configurationProperties, (Logger)LOGGER);
    }
}

