/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

import static java.util.Collections.emptyList;
import static java.util.Optional.empty;
import org.mule.maven.client.api.model.RemoteRepository;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class Pojo {
  List<RemoteRepository> remoteRepositories = new LinkedList<>();
  File localMavenRepositoryLocation;
  Optional<File> userSettingsFileOptional = empty();
  Optional<File> globalSettingsFileOptional = empty();
  boolean forcePolicyUpdateNever = false;
  boolean offlineMode = false;
  boolean ignoreArtifactDescriptorRepositories = true;
  // Should not use Optional type here, as this field was added on later verions and will be null
  // when deserializing a previous version of this instance.
  File settingsSecurityFile;
  List<String> activeProfiles = emptyList();
  List<String> inactiveProfiles = emptyList();
  Properties userProperties;

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    Pojo pojo = (Pojo) o;

    if (forcePolicyUpdateNever != pojo.forcePolicyUpdateNever) {
      return false;
    }
    if (offlineMode != pojo.offlineMode) {
      return false;
    }
    if (ignoreArtifactDescriptorRepositories != pojo.ignoreArtifactDescriptorRepositories) {
      return false;
    }
    if (!remoteRepositories.equals(pojo.remoteRepositories)) {
      return false;
    }
    if (localMavenRepositoryLocation != null ?
        !localMavenRepositoryLocation.equals(pojo.localMavenRepositoryLocation) :
        pojo.localMavenRepositoryLocation != null) {
      return false;
    }
    if (!userSettingsFileOptional.equals(pojo.userSettingsFileOptional)) {
      return false;
    }
    if (!globalSettingsFileOptional.equals(pojo.globalSettingsFileOptional)) {
      return false;
    }
    if (settingsSecurityFile != null ?
        !settingsSecurityFile.equals(pojo.settingsSecurityFile) :
        pojo.settingsSecurityFile != null) {
      return false;
    }
    if (!activeProfiles.equals(pojo.activeProfiles)) {
      return false;
    }
    if (!inactiveProfiles.equals(pojo.inactiveProfiles)) {
      return false;
    }
    return userProperties != null ? userProperties.equals(pojo.userProperties) : pojo.userProperties == null;
  }

  @Override
  public int hashCode() {
    int result = remoteRepositories.hashCode();
    result = 31 * result + (localMavenRepositoryLocation != null ? localMavenRepositoryLocation.hashCode() : 0);
    result = 31 * result + userSettingsFileOptional.hashCode();
    result = 31 * result + globalSettingsFileOptional.hashCode();
    result = 31 * result + (forcePolicyUpdateNever ? 1 : 0);
    result = 31 * result + (offlineMode ? 1 : 0);
    result = 31 * result + (ignoreArtifactDescriptorRepositories ? 1 : 0);
    result = 31 * result + (settingsSecurityFile != null ? settingsSecurityFile.hashCode() : 0);
    result = 31 * result + activeProfiles.hashCode();
    result = 31 * result + inactiveProfiles.hashCode();
    result = 31 * result + (userProperties != null ? userProperties.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "Pojo{" +
        "remoteRepositories=" + remoteRepositories +
        ", localMavenRepositoryLocation=" + localMavenRepositoryLocation +
        ", userSettingsFileOptional=" + userSettingsFileOptional +
        ", globalSettingsFileOptional=" + globalSettingsFileOptional +
        ", forcePolicyUpdateNever=" + forcePolicyUpdateNever +
        ", offlineMode=" + offlineMode +
        ", ignoreArtifactDescriptorRepositories=" + ignoreArtifactDescriptorRepositories +
        ", settingsSecurityFile=" + settingsSecurityFile +
        ", activeProfiles=" + activeProfiles +
        ", inactiveProfiles=" + inactiveProfiles +
        ", userProperties=" + userProperties +
        '}';
  }
}
