/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.collection.IsIterableContainingInOrder.contains;
import static org.mule.tooling.client.internal.hamcrest.HamcrestUtils.validateThat;

import org.mule.tooling.client.api.extension.model.value.ValueProviderModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ValueProviderMatcher<T extends ValueProviderModel, R extends org.mule.runtime.api.meta.model.parameter.ValueProviderModel>
    extends TypeSafeDiagnosingMatcher<T> {

  public static <T extends ValueProviderModel, R extends org.mule.runtime.api.meta.model.parameter.ValueProviderModel> Matcher<T> from(R runtimeValueProviderModel) {
    return new ValueProviderMatcher<>(runtimeValueProviderModel);
  }

  protected final R runtimeValueProviderModel;

  protected ValueProviderMatcher(R runtimeValueProviderModel) {
    this.runtimeValueProviderModel = runtimeValueProviderModel;
  }

  @Override
  protected boolean matchesSafely(ValueProviderModel valueProviderModel, Description description) {
    return validateThat("requiresConfiguration", valueProviderModel.requiresConfiguration(),
                        equalTo(runtimeValueProviderModel.requiresConfiguration()), description)
        &&
        validateThat("requiresConnection", valueProviderModel.requiresConnection(),
                     equalTo(runtimeValueProviderModel.requiresConnection()), description)
        &&
        validateThat("isOpen", valueProviderModel.isOpen(), equalTo(runtimeValueProviderModel.isOpen()), description) &&
        validateThat("partOrder", valueProviderModel.getPartOrder(), equalTo(runtimeValueProviderModel.getPartOrder()),
                     description)
        &&
        validateThat("actingParameters", valueProviderModel.getActingParameters(),
                     equalTo(runtimeValueProviderModel.getActingParameters()), description)
        &&
        validateThat("providerName", valueProviderModel.getProviderName(), equalTo(runtimeValueProviderModel.getProviderName()),
                     description)
        &&
        (!valueProviderModel.getProviderId().isEnabled() ||
            validateThat("providerId", valueProviderModel.getProviderId().get(),
                         equalTo(runtimeValueProviderModel.getProviderId()), description))
        &&
        (!valueProviderModel.getParameters().isEnabled() ||
            (runtimeValueProviderModel.getParameters().isEmpty()
                ? validateThat("actingParameterModels", valueProviderModel.getParameters().get(), hasSize(0), description)
                : validateThat("ActingParameterModels", valueProviderModel.getParameters().get(),
                               contains(ActingParameterMatcher.sFrom(runtimeValueProviderModel.getParameters())), description)));
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ValueProviderModel: ").appendValue(runtimeValueProviderModel);
  }

}
