/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;


import static java.util.Optional.empty;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.mule.tooling.client.internal.hamcrest.HamcrestUtils.validateThat;

import org.mule.tooling.client.api.extension.model.StereotypeModel;

import java.util.Collection;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class StereotypeMatcher extends TypeSafeDiagnosingMatcher<StereotypeModel> {

  private final org.mule.runtime.api.meta.model.stereotype.StereotypeModel runtimeStereotypeModel;

  public static Matcher<StereotypeModel>[] sFrom(Collection<org.mule.runtime.api.meta.model.stereotype.StereotypeModel> runtimeStereotypeModels) {
    return runtimeStereotypeModels.stream().map(StereotypeMatcher::from).toArray(StereotypeMatcher[]::new);
  }

  public static Matcher<StereotypeModel> from(org.mule.runtime.api.meta.model.stereotype.StereotypeModel runtimeStereotypeModel) {
    if (runtimeStereotypeModel == null) {
      return nullValue(StereotypeModel.class);
    }
    return new StereotypeMatcher(runtimeStereotypeModel);
  }

  private StereotypeMatcher(org.mule.runtime.api.meta.model.stereotype.StereotypeModel runtimeStereotypeModel) {
    this.runtimeStereotypeModel = runtimeStereotypeModel;
  }

  @Override
  protected boolean matchesSafely(StereotypeModel stereotypeModel, Description description) {
    return validateThat("namespace", stereotypeModel.getNamespace(), equalTo(runtimeStereotypeModel.getNamespace()), description)
        &&
        validateThat("type", stereotypeModel.getType(), equalTo(runtimeStereotypeModel.getType()), description) &&
        runtimeStereotypeModel
            .getParent()
            .map(rp -> stereotypeModel
                .getParent()
                .map(p -> validateThat("parent", p, from(rp), description))
                .orElse(false))
            .orElseGet(() -> validateThat("parent", stereotypeModel.getParent(), equalTo(empty()), description));
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("StereotypeModel: ").appendValue(runtimeStereotypeModel);
  }

}
