/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.metadata.ResolverInformation;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ResolverInformationMatcher extends TypeSafeMatcher<ResolverInformation> {

  public static Matcher<ResolverInformation> from(org.mule.runtime.extension.api.property.ResolverInformation runtimeResolverInformation) {
    if (runtimeResolverInformation == null) {
      return nullValue(ResolverInformation.class);
    }
    return new ResolverInformationMatcher(runtimeResolverInformation);
  }

  private final org.mule.runtime.extension.api.property.ResolverInformation runtimeResolverInformation;

  private ResolverInformationMatcher(org.mule.runtime.extension.api.property.ResolverInformation runtimeResolverInformation) {
    this.runtimeResolverInformation = runtimeResolverInformation;
  }

  @Override
  protected boolean matchesSafely(ResolverInformation item) {
    return item.getResolverName().equals(runtimeResolverInformation.getResolverName()) &&
        item.isRequiresConfiguration() == runtimeResolverInformation.isRequiresConfiguration() &&
        item.isRequiresConnection() == runtimeResolverInformation.isRequiresConnection();
  }

  @Override
  protected void describeMismatchSafely(ResolverInformation item, Description mismatchDescription) {
    mismatchDescription.appendText("was ResolverInformation: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ResolverInformation: ").appendValue(runtimeResolverInformation);
  }
}
