/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.PathModel;
import org.mule.tooling.client.api.extension.model.PathModelLocation;
import org.mule.tooling.client.api.extension.model.PathModelType;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PathModelMatcher extends TypeSafeMatcher<PathModel> {

  private final org.mule.runtime.api.meta.model.display.PathModel runtimePathModel;

  public static Matcher<PathModel> from(org.mule.runtime.api.meta.model.display.PathModel runtimePathModel) {
    if (runtimePathModel == null) {
      return nullValue(PathModel.class);
    }
    return new PathModelMatcher(runtimePathModel);
  }

  private PathModelMatcher(org.mule.runtime.api.meta.model.display.PathModel runtimePathModel) {
    this.runtimePathModel = runtimePathModel;
  }

  @Override
  protected boolean matchesSafely(PathModel pathModel) {
    return runtimePathModel.acceptsUrls() == pathModel.acceptsUrls() &&
        runtimePathModel.getFileExtensions().equals(pathModel.getFileExtensions()) &&
        comparePathModelLocation(pathModel.getLocation()) &&
        comparePathType(pathModel.getType());
  }

  private boolean comparePathModelLocation(PathModelLocation location) {
    switch (runtimePathModel.getLocation()) {
      case EXTERNAL:
        return location.isExternal();
      case EMBEDDED:
        return location.isEmbedded();
      case ANY:
        return location.isAny();
    }
    return false;
  }

  private boolean comparePathType(PathModelType type) {
    switch (runtimePathModel.getType()) {
      case FILE:
        return type.isFile();
      case DIRECTORY:
        return type.isDirectory();
      case ANY:
        return type.isAny();
    }
    return false;
  }

  @Override
  protected void describeMismatchSafely(PathModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was ").appendText("PathModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("PathModel: ").appendValue(runtimePathModel);
  }
}
