/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ParameterRoleMatcher extends TypeSafeMatcher<ParameterRole> {

  public static Matcher<ParameterRole> from(org.mule.runtime.api.meta.model.parameter.ParameterRole runtimeParameterRole) {
    if (runtimeParameterRole == null) {
      return nullValue(ParameterRole.class);
    }
    return new ParameterRoleMatcher(runtimeParameterRole);
  }

  private final org.mule.runtime.api.meta.model.parameter.ParameterRole runtimeParameterRole;

  private ParameterRoleMatcher(org.mule.runtime.api.meta.model.parameter.ParameterRole runtimeParameterRole) {
    this.runtimeParameterRole = runtimeParameterRole;
  }

  @Override
  protected boolean matchesSafely(ParameterRole parameterRole) {
    switch (runtimeParameterRole) {
      case CONTENT:
        return parameterRole.isContent();
      case BEHAVIOUR:
        return parameterRole.isBehaviour();
      case PRIMARY_CONTENT:
        return parameterRole.isPrimaryContent();
    }
    return false;
  }

  @Override
  protected void describeMismatchSafely(ParameterRole item, Description mismatchDescription) {
    mismatchDescription.appendText("was ParameterRole: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ParameterRole: ").appendValue(runtimeParameterRole);
  }

}
