/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.nested.NestedChainModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class NestedChainMatcher extends NestedComponentMatcher<NestedChainModel> {

  public static Matcher<NestedChainModel> from(org.mule.runtime.api.meta.model.nested.NestedChainModel runtimeModel) {
    if (runtimeModel == null) {
      return nullValue(NestedChainModel.class);
    }
    return new NestedChainMatcher(runtimeModel);
  }

  protected NestedChainMatcher(org.mule.runtime.api.meta.model.nested.NestedChainModel runtimeNestedComponentModel) {
    super(runtimeNestedComponentModel);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("NestedChainModel: ").appendValue(runtimeNestedComponentModel);
  }
}
