/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyPartModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MetadataKeyPartMatcher extends TypeSafeMatcher<MetadataKeyPartModel> {

  public static Matcher<MetadataKeyPartModel> from(MetadataKeyPartModelProperty runtimeModelProperty) {
    if (runtimeModelProperty == null) {
      return nullValue(MetadataKeyPartModel.class);
    }
    return new MetadataKeyPartMatcher(runtimeModelProperty);
  }

  private final MetadataKeyPartModelProperty runtimeModelProperty;

  private MetadataKeyPartMatcher(MetadataKeyPartModelProperty runtimeModelProperty) {
    this.runtimeModelProperty = runtimeModelProperty;
  }

  @Override
  protected boolean matchesSafely(MetadataKeyPartModel metadataKeyPartModel) {
    return runtimeModelProperty.isProvidedByKeyResolver() == metadataKeyPartModel.isProvidedByKeyResolver() &&
        runtimeModelProperty.getOrder() == metadataKeyPartModel.getOrder();
  }

  @Override
  protected void describeMismatchSafely(MetadataKeyPartModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was MetadataKeyPartModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("MetadataKeyPartModel: ").appendValue(runtimeModelProperty);
  }

}
