/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.LayoutModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LayoutModelMatcher extends TypeSafeMatcher<LayoutModel> {

  public static Matcher<LayoutModel> from(org.mule.runtime.api.meta.model.display.LayoutModel runtimeLayoutModel) {
    if (runtimeLayoutModel == null) {
      return nullValue(LayoutModel.class);
    }
    return new LayoutModelMatcher(runtimeLayoutModel);
  }

  private final org.mule.runtime.api.meta.model.display.LayoutModel runtimeLayoutModel;

  private LayoutModelMatcher(org.mule.runtime.api.meta.model.display.LayoutModel runtimeLayoutModel) {
    this.runtimeLayoutModel = runtimeLayoutModel;
  }

  @Override
  protected boolean matchesSafely(LayoutModel layoutModel) {
    return runtimeLayoutModel.isPassword() == layoutModel.isPassword() &&
        runtimeLayoutModel.isQuery() == layoutModel.isQuery() &&
        runtimeLayoutModel.isText() == layoutModel.isText() &&
        runtimeLayoutModel
            .getOrder()
            .map(ro -> layoutModel.getOrder().map(ro::equals).orElse(false))
            .orElse(!layoutModel.getOrder().isPresent())
        &&
        runtimeLayoutModel
            .getTabName()
            .map(rtn -> layoutModel.getTabName().map(rtn::equals).orElse(false))
            .orElse(!layoutModel.getTabName().isPresent());
  }

  @Override
  protected void describeMismatchSafely(LayoutModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was LayoutModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("LayoutModel: ").appendValue(runtimeLayoutModel);
  }

}
