/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.ExpressionSupport;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ExpressionSupportMatcher extends TypeSafeMatcher<ExpressionSupport> {

  public static Matcher<ExpressionSupport> from(org.mule.runtime.api.meta.ExpressionSupport runtimeExpressionSupport) {
    if (runtimeExpressionSupport == null) {
      return nullValue(ExpressionSupport.class);
    }
    return new ExpressionSupportMatcher(runtimeExpressionSupport);
  }

  private final org.mule.runtime.api.meta.ExpressionSupport runtimeExpressionSupport;

  private ExpressionSupportMatcher(org.mule.runtime.api.meta.ExpressionSupport runtimeExpressionSupport) {
    this.runtimeExpressionSupport = runtimeExpressionSupport;
  }

  @Override
  protected boolean matchesSafely(ExpressionSupport expressionSupport) {
    switch (runtimeExpressionSupport) {
      case REQUIRED:
        return expressionSupport.isRequired();
      case SUPPORTED:
        return expressionSupport.isSupported();
      case NOT_SUPPORTED:
        return expressionSupport.isNotSupported();
    }
    return false;
  }

  @Override
  protected void describeMismatchSafely(ExpressionSupport item, Description mismatchDescription) {
    mismatchDescription.appendText("was ExpressionSupport: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ExpressionSupport: ").appendValue(runtimeExpressionSupport);
  }

}
