/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.DisplayModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class DisplayModelMatcher extends TypeSafeMatcher<DisplayModel> {

  public static Matcher<DisplayModel> from(org.mule.runtime.api.meta.model.display.DisplayModel runtimeDisplayModel) {
    if (runtimeDisplayModel == null) {
      return nullValue(DisplayModel.class);
    }
    return new DisplayModelMatcher(runtimeDisplayModel);
  }

  private final org.mule.runtime.api.meta.model.display.DisplayModel runtimeDisplayModel;

  private DisplayModelMatcher(org.mule.runtime.api.meta.model.display.DisplayModel runtimeDisplayModel) {
    this.runtimeDisplayModel = runtimeDisplayModel;
  }

  @Override
  protected boolean matchesSafely(DisplayModel displayModel) {
    return runtimeDisplayModel.getDisplayName().equals(displayModel.getDisplayName()) &&
        runtimeDisplayModel.getExample().equals(displayModel.getExample()) &&
        runtimeDisplayModel.getSummary().equals(displayModel.getSummary()) &&
        runtimeDisplayModel
            .getPathModel()
            .map(rpm -> displayModel
                .getPathModel()
                .map(pm -> PathModelMatcher.from(rpm).matches(pm))
                .orElse(false))
            .orElse(!displayModel.getPathModel().isPresent())
        &&
        (!displayModel.getClassValueModel().isEnabled() ||
            runtimeDisplayModel
                .getClassValueModel()
                .map(rcvm -> displayModel
                    .getClassValueModel()
                    .get()
                    .map(cvm -> rcvm.getAssignableFrom().equals(cvm.getAssignableFrom()))
                    .orElse(false))
                .orElse(!displayModel.getClassValueModel().get().isPresent()));
  }

  @Override
  protected void describeMismatchSafely(DisplayModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was DisplayModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("DisplayModel: ").appendValue(runtimeDisplayModel);
  }

}
