/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class DeprecationModelMatcher extends TypeSafeMatcher<DeprecationModel> {

  public static Matcher<DeprecationModel> from(org.mule.runtime.api.meta.model.deprecated.DeprecationModel runtimeDeprecationModel) {
    if (runtimeDeprecationModel == null) {
      return nullValue(DeprecationModel.class);
    }
    return new DeprecationModelMatcher(runtimeDeprecationModel);
  }

  private final org.mule.runtime.api.meta.model.deprecated.DeprecationModel runtimeDeprecationModel;

  private DeprecationModelMatcher(org.mule.runtime.api.meta.model.deprecated.DeprecationModel runtimeDeprecationModel) {
    this.runtimeDeprecationModel = runtimeDeprecationModel;
  }

  @Override
  protected boolean matchesSafely(DeprecationModel deprecationModel) {
    return runtimeDeprecationModel.getDeprecatedSince().equals(deprecationModel.getDeprecatedSince()) &&
        runtimeDeprecationModel.getMessage().equals(deprecationModel.getMessage()) &&
        runtimeDeprecationModel
            .getToRemoveIn()
            .map(rtri -> deprecationModel.getToRemoveIn().map(tri -> tri.equals(rtri)).orElse(false))
            .orElse(!deprecationModel.getToRemoveIn().isPresent());
  }

  @Override
  protected void describeMismatchSafely(DeprecationModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was DeprecationModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("DeprecationModel: ").appendValue(runtimeDeprecationModel);
  }

}
