/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;


import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.parameter.ActingParameterModel;

import java.util.Collection;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ActingParameterMatcher extends TypeSafeMatcher<ActingParameterModel> {

  private final org.mule.runtime.api.meta.model.parameter.ActingParameterModel runtimeActingParameterModel;

  public static Matcher<ActingParameterModel>[] sFrom(Collection<org.mule.runtime.api.meta.model.parameter.ActingParameterModel> runtimeActingParameters) {
    return runtimeActingParameters.stream().map(ActingParameterMatcher::from).toArray(ActingParameterMatcher[]::new);
  }

  public static Matcher<ActingParameterModel> from(org.mule.runtime.api.meta.model.parameter.ActingParameterModel runtimeActingParameterModel) {
    if (runtimeActingParameterModel == null) {
      return nullValue(ActingParameterModel.class);
    }
    return new ActingParameterMatcher(runtimeActingParameterModel);
  }

  private ActingParameterMatcher(org.mule.runtime.api.meta.model.parameter.ActingParameterModel runtimeActingParameterModel) {
    this.runtimeActingParameterModel = runtimeActingParameterModel;
  }

  @Override
  protected boolean matchesSafely(ActingParameterModel actingParameterModel) {
    return actingParameterModel.isRequired() == runtimeActingParameterModel.isRequired() &&
        actingParameterModel.getName().equals(runtimeActingParameterModel.getName()) &&
        actingParameterModel.getExtractionExpression().isEnabled() &&
        actingParameterModel.getExtractionExpression().get().equals(runtimeActingParameterModel.getExtractionExpression());
  }

  @Override
  protected void describeMismatchSafely(ActingParameterModel item, Description mismatchDescription) {
    mismatchDescription
        .appendText("was ")
        .appendText("ActingParameterModel: ")
        .appendText(item.getName())
        .appendText(", ")
        .appendText(item.isRequired() ? "" : "NOT")
        .appendText(" Required");
  }

  @Override
  public void describeTo(Description description) {
    description
        .appendText("ActingParameterModel: ")
        .appendText(runtimeActingParameterModel.getName())
        .appendText(", ")
        .appendText(runtimeActingParameterModel.isRequired() ? "" : "NOT")
        .appendText(" Required");
  }
}
