/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.tooling.client.api.feature.Feature;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.is;
import static org.mule.tooling.client.api.feature.Feature.enabled;

public class CommandServiceTestCase {

  private static final String TEST_MESSAGE = "Hello World";
  private Command service = new MyServiceImpl();

  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  @Test
  public void testServiceIsNotFeature() {
    expectedException.expect(IllegalArgumentException.class);
    expectedException.expectMessage("is not a Feature");
    service.isFeatureEnabled("service", new String[] {});
  }

  @Test
  public void testServiceIsFeatureEnabled() {
    assertThat(service.isFeatureEnabled("featureService", new String[] {}), is(true));
  }

  @Test
  public void testServiceIsOverloadingFeatureEnabled() {
    assertThat(service.isFeatureEnabled("featureService", new String[] {String.class.getName()}), is(true));
  }

  @Test
  public void testUndefinedFeature() {
    assertThat(service.isFeatureEnabled("newSuperFunFeatureService", new String[] {}), is(false));
  }

  private class MyServiceImpl implements Command {

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
      // not really going to use this in the test
      return null;
    }

    public String service() {
      return TEST_MESSAGE;
    }

    public Feature<String> featureService() {
      return enabled(TEST_MESSAGE);
    }

    public Feature<String> featureService(String value) {
      return enabled(value);
    }
  }
}
