/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.artifact;

import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.DefaultResourceLocator;
import org.mule.tooling.client.api.artifact.resources.ResourceLoader;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DefaultResourceLoader
implements ResourceLoader,
Command {
    private DefaultResourceLocator.ResourceLoaderFormatter formatter = new DefaultResourceLocator.ResourceLoaderFormatter();
    private Artifact artifact;
    private Serializer serializer;

    public DefaultResourceLoader(Artifact artifact, Serializer serializer) {
        this.artifact = artifact;
        this.serializer = serializer;
    }

    public InputStream getResourceAsStream(String resource) {
        return this.getClassLoader().getResourceAsStream(resource);
    }

    public Optional<URL> findIn(String resource, String groupId, String artifactId, Optional<String> version, String classifier, String type) {
        return Optional.ofNullable(this.getResource(this.formatter.format(resource, groupId, artifactId, version, classifier, type)));
    }

    public Optional<InputStream> loadFrom(String resource, String groupId, String artifactId, Optional<String> version, String classifier, String type) {
        return Optional.ofNullable(this.getResourceAsStream(this.formatter.format(resource, groupId, artifactId, version, classifier, type)));
    }

    private ClassLoader getClassLoader() {
        return this.artifact.getArtifactClassLoader().getRegionClassLoader().getClassLoader();
    }

    public URL getResource(String resource) {
        return this.getClassLoader().getResource(resource);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getResourceAsStream": {
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.getResourceAsStream(arguments[0]);
            }
            case "getResource": {
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.getResource(arguments[0]);
            }
            case "findIn": {
                Preconditions.checkState((classes.length == 6 && classes[0].equals(String.class.getName()) && classes[1].equals(String.class.getName()) && classes[2].equals(String.class.getName()) && classes[3].equals(Optional.class.getName()) && classes[4].equals(String.class.getName()) && classes[5].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.findIn(arguments[0], arguments[1], arguments[2], (Optional)this.serializer.deserialize(arguments[3]), arguments[4], arguments[5]);
            }
            case "loadFrom": {
                Preconditions.checkState((classes.length == 6 && classes[0].equals(String.class.getName()) && classes[1].equals(String.class.getName()) && classes[2].equals(String.class.getName()) && classes[3].equals(Optional.class.getName()) && classes[4].equals(String.class.getName()) && classes[5].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.loadFrom(arguments[0], arguments[1], arguments[2], (Optional)this.serializer.deserialize(arguments[3]), arguments[4], arguments[5]);
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

