/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import org.mule.tooling.api.sampledata.SampleDataMessageModelFailure;
import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.sampledata.ComponentSampleDataResult;
import org.mule.tooling.client.api.sampledata.SampleDataService;
import org.mule.tooling.client.api.sampledata.request.SampleDataRequest;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.utils.SampleDataUtils;

public class SampleDataProviderServiceAdapter
implements SampleDataService,
Command {
    private final RemoteApplicationInvoker remoteApplicationInvoker;
    private final Serializer serializer;

    public SampleDataProviderServiceAdapter(RemoteApplicationInvoker remoteApplicationInvoker, Serializer serializer) {
        Preconditions.checkNotNull((Object)remoteApplicationInvoker, (Object)"remote application invoker cannot be null");
        Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.remoteApplicationInvoker = remoteApplicationInvoker;
        this.serializer = serializer;
    }

    public ComponentSampleDataResult getSampleData(SampleDataRequest sampleDataRequest) {
        try {
            return SampleDataUtils.toComponentSampleDataResult(this.remoteApplicationInvoker.evaluateWithRemoteApplication((appId, toolingService) -> toolingService.getSampleDataApplication(appId, sampleDataRequest.getLocation(), sampleDataRequest.getRequestTimeout())));
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            return SampleDataUtils.toComponentSampleDataResult(new SampleDataMessageModelResult(new SampleDataMessageModelFailure(e)));
        }
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        if ("getSampleData".equals(methodName)) {
            this.validateInput(arguments, classes, new Class[]{SampleDataRequest.class});
            SampleDataRequest sampleDataRequest = (SampleDataRequest)this.serializer.deserialize(arguments[0]);
            return this.serializer.serialize((Object)this.getSampleData(sampleDataRequest));
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

