/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.Maps;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ImportedTypeModel;
import org.mule.tooling.client.api.extension.model.SubTypesModel;
import org.mule.tooling.client.api.extension.model.XmlDslModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.function.FunctionModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.CollectionUtils;
import org.mule.tooling.client.internal.ExtensionModelPartsFactory;

public class ExtensionModelFactory {
    private Map<String, ConnectionProviderModel> connectionProviderModelsCache = Maps.newHashMap();
    private Map<String, SourceModel> sourceModelsCache = Maps.newHashMap();
    private Map<String, org.mule.tooling.client.api.extension.model.operation.OperationModel> operationModelsCache = Maps.newHashMap();
    private Map<String, ConstructModel> constructModelsCache = Maps.newHashMap();
    private Map<String, FunctionModel> functionModelsCache = Maps.newHashMap();
    private Map<String, ErrorModel> errorModelsCache = Maps.newHashMap();
    private ExtensionModelPartsFactory extensionModelPartsFactory;

    public ExtensionModelFactory(Optional<MuleVersion> targetRuntimeVersion) {
        this.extensionModelPartsFactory = new ExtensionModelPartsFactory(targetRuntimeVersion);
    }

    public org.mule.tooling.client.api.extension.model.ExtensionModel createExtensionModel(ExtensionModel runtimeExtensionModel, String minMuleVersion) {
        return new org.mule.tooling.client.api.extension.model.ExtensionModel(runtimeExtensionModel.getName(), ExtensionModelFactory.toCategoryDTO(runtimeExtensionModel.getCategory()), runtimeExtensionModel.getVendor(), CollectionUtils.copy(runtimeExtensionModel.getResources()), (Set)runtimeExtensionModel.getImportedTypes().stream().map(importedTypeModel -> new ImportedTypeModel(importedTypeModel.getImportedType())).collect(Collectors.toCollection(LinkedHashSet::new)), (Set)runtimeExtensionModel.getSubTypes().stream().map(subTypesModel -> new SubTypesModel(subTypesModel.getBaseType(), subTypesModel.getSubTypes())).collect(Collectors.toCollection(LinkedHashSet::new)), runtimeExtensionModel.getTypes(), minMuleVersion, runtimeExtensionModel.getVersion(), new XmlDslModel(runtimeExtensionModel.getXmlDslModel().getXsdFileName(), runtimeExtensionModel.getXmlDslModel().getSchemaVersion(), runtimeExtensionModel.getXmlDslModel().getPrefix(), runtimeExtensionModel.getXmlDslModel().getNamespace(), runtimeExtensionModel.getXmlDslModel().getSchemaLocation()), runtimeExtensionModel.getDescription(), ExtensionModelPartsFactory.toDisplayModelDTO(runtimeExtensionModel.getDisplayModel()), this.extensionModelPartsFactory.toExternalLibraryModelsDTO(runtimeExtensionModel.getExternalLibraryModels()), this.toConfigurationModelsDTO(runtimeExtensionModel), this.toOperationModelsDTO(runtimeExtensionModel.getOperationModels()), this.toConnectionProvidersDTO(runtimeExtensionModel.getConnectionProviders()), this.toSourceModelsDTO(runtimeExtensionModel.getSourceModels()), this.toFunctionModelsDTO(runtimeExtensionModel.getFunctionModels()), this.toConstructModelsDTO(runtimeExtensionModel.getConstructModels()), this.toErrorModelsDTO(runtimeExtensionModel.getErrorModels()), ExtensionModelPartsFactory.toDeprecationModelDTO(runtimeExtensionModel.getDeprecationModel().orElse(null)), runtimeExtensionModel.getSupportedJavaVersions());
    }

    private static org.mule.tooling.client.api.extension.model.Category toCategoryDTO(Category category) {
        if (category == Category.COMMUNITY) {
            return org.mule.tooling.client.api.extension.model.Category.communityCategory((String)category.name());
        }
        if (category == Category.SELECT) {
            return org.mule.tooling.client.api.extension.model.Category.selectCategory((String)category.name());
        }
        if (category == Category.PREMIUM) {
            return org.mule.tooling.client.api.extension.model.Category.premiumCategory((String)category.name());
        }
        if (category == Category.CERTIFIED) {
            return org.mule.tooling.client.api.extension.model.Category.certifiedCategory((String)category.name());
        }
        return new org.mule.tooling.client.api.extension.model.Category(category.name());
    }

    private List<ConfigurationModel> toConfigurationModelsDTO(ExtensionModel serializedExtensionModel) {
        return serializedExtensionModel.getConfigurationModels().stream().map(configurationModel -> new ConfigurationModel(configurationModel.getName(), configurationModel.getDescription(), ExtensionModelPartsFactory.toParameterGroupModelsDTO(ExtensionModelPartsFactory.createValueProviderEnricher((ParameterizedModel)configurationModel), configurationModel.getParameterGroupModels()), this.toOperationModelsDTO(configurationModel.getOperationModels()), this.extensionModelPartsFactory.toExternalLibraryModelsDTO(configurationModel.getExternalLibraryModels()), this.toSourceModelsDTO(configurationModel.getSourceModels()), this.toConnectionProvidersDTO(configurationModel.getConnectionProviders()), ExtensionModelPartsFactory.toDisplayModelDTO(configurationModel.getDisplayModel()), ExtensionModelPartsFactory.toStereotypeDTO(configurationModel.getStereotype()), ExtensionModelPartsFactory.toDeprecationModelDTO(configurationModel.getDeprecationModel().orElse(null)))).collect(Collectors.toList());
    }

    private List<org.mule.tooling.client.api.extension.model.operation.OperationModel> toOperationModelsDTO(List<OperationModel> operationModels) {
        return operationModels.stream().map(operationModel -> this.operationModelsCache.computeIfAbsent(operationModel.getName(), name -> this.extensionModelPartsFactory.toOperationModelDTO((OperationModel)operationModel))).collect(Collectors.toList());
    }

    private List<SourceModel> toSourceModelsDTO(List<org.mule.runtime.api.meta.model.source.SourceModel> sourceModels) {
        return sourceModels.stream().map(sourceModel -> sourceModel == null ? null : this.sourceModelsCache.computeIfAbsent(sourceModel.getName(), name -> this.extensionModelPartsFactory.toSourceModelDTO((org.mule.runtime.api.meta.model.source.SourceModel)sourceModel))).collect(Collectors.toList());
    }

    private List<ConnectionProviderModel> toConnectionProvidersDTO(List<org.mule.runtime.api.meta.model.connection.ConnectionProviderModel> connectionProviders) {
        return connectionProviders.stream().map(connectionProviderModel -> this.connectionProviderModelsCache.computeIfAbsent(connectionProviderModel.getName(), name -> this.extensionModelPartsFactory.toConnectionProviderDTO((org.mule.runtime.api.meta.model.connection.ConnectionProviderModel)connectionProviderModel))).collect(Collectors.toList());
    }

    private List<FunctionModel> toFunctionModelsDTO(List<org.mule.runtime.api.meta.model.function.FunctionModel> functionModels) {
        return functionModels.stream().map(functionModel -> this.functionModelsCache.computeIfAbsent(functionModel.getName(), name -> this.extensionModelPartsFactory.toFunctionModelDTO((org.mule.runtime.api.meta.model.function.FunctionModel)functionModel))).collect(Collectors.toList());
    }

    private List<ConstructModel> toConstructModelsDTO(List<org.mule.runtime.api.meta.model.construct.ConstructModel> constructModels) {
        return constructModels.stream().map(constructModel -> this.constructModelsCache.computeIfAbsent(constructModel.getName(), name -> this.extensionModelPartsFactory.toConstructModelDTO((org.mule.runtime.api.meta.model.construct.ConstructModel)constructModel))).collect(Collectors.toList());
    }

    private ErrorModel toErrorModelDTO(org.mule.runtime.api.meta.model.error.ErrorModel errorModel) {
        if (errorModel == null) {
            return null;
        }
        return new ErrorModel(errorModel.getType(), errorModel.getNamespace(), errorModel.isHandleable(), this.toErrorModelDTO(errorModel.getParent().orElse(null)));
    }

    private Set<ErrorModel> toErrorModelsDTO(Set<org.mule.runtime.api.meta.model.error.ErrorModel> errorModels) {
        return errorModels.stream().map(errorModel -> this.errorModelsCache.computeIfAbsent(errorModel.getNamespace() + ":" + errorModel.getType(), name -> this.toErrorModelDTO((org.mule.runtime.api.meta.model.error.ErrorModel)errorModel))).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

