/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.AbstractMuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.InternalSchemaService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.utils.BundleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedExtensionModelService
extends AbstractMuleRuntimeExtensionModelProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InternalSchemaService internalSchemaService;
    private ExtensionModelServiceCache extensionModelServiceCache;

    public CachedExtensionModelService(MavenClient mavenClient, ExtensionModelServiceCache extensionModelServiceCache, InternalExtensionModelService extensionModelService, InternalSchemaService internalSchemaService) {
        super(mavenClient, extensionModelService);
        this.extensionModelServiceCache = extensionModelServiceCache;
        this.internalSchemaService = internalSchemaService;
    }

    @Override
    public Optional<ExtensionModel> getExtensionModel(ArtifactDescriptor pluginDescriptor) {
        this.checkArtifactDescriptor(pluginDescriptor);
        return this.extensionModelServiceCache.loadExtensionInformation(this.resolveBundleDependency(this.toBundleDescriptor(pluginDescriptor)), this.extensionModelService).map(loadedExtensionInformation -> loadedExtensionInformation.getExtensionModel());
    }

    private void checkArtifactDescriptor(ArtifactDescriptor pluginDescriptor) {
        if (pluginDescriptor.getProperties().containsKey("mule.disableSdkComponentIgnore")) {
            throw new UnsupportedOperationException("mule.disableSdkComponentIgnore cannot be set at request level, only supported as System Property.");
        }
        if (pluginDescriptor.getProperties().containsKey("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE")) {
            throw new UnsupportedOperationException("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE cannot be set at request level when extension model cache is enabled");
        }
    }

    @Override
    public Optional<String> getMinMuleVersion(ArtifactDescriptor pluginDescriptor) {
        this.checkArtifactDescriptor(pluginDescriptor);
        return this.extensionModelServiceCache.loadExtensionInformation(this.resolveBundleDependency(this.toBundleDescriptor(pluginDescriptor)), this.extensionModelService).map(loadedExtensionInformation -> loadedExtensionInformation.getMinMuleVersion());
    }

    @Override
    public Optional<LoadedExtensionInformation> getExtensionModel(File plugin) {
        return this.extensionModelService.loadExtensionData(plugin);
    }

    @Override
    public Set<ExtensionModel> loadExtensionModels(List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return this.extensionModelServiceCache.loadExtensionModels(artifactPluginClassLoaders, this.extensionModelService);
    }

    @Override
    public Optional<ExtensionModel> getExtensionModel(BundleDependency bundleDependency) {
        return this.extensionModelServiceCache.loadExtensionInformation(bundleDependency, this.extensionModelService).map(loadedExtensionInformation -> loadedExtensionInformation.getExtensionModel());
    }

    @Override
    public Optional<String> getMinMuleVersion(File plugin) {
        return this.extensionModelService.loadExtensionData(plugin).map(loadedExtensionInformation -> loadedExtensionInformation.getMinMuleVersion());
    }

    @Override
    public Optional<String> getExtensionSchema(File plugin) {
        try {
            Optional<String> schemaOptional = this.internalSchemaService.getSchema(plugin);
            if (schemaOptional.isPresent()) {
                return schemaOptional;
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot extract schema for artifact:{} ", (Object)plugin, (Object)e);
        }
        return this.extensionModelService.loadExtensionData(plugin).map(loadedExtensionInformation -> (String)loadedExtensionInformation.getSchema().get());
    }

    @Override
    public Optional<String> getExtensionSchema(ArtifactDescriptor pluginDescriptor) {
        BundleDependency bundleDependency = this.resolveBundleDependency(this.toBundleDescriptor(pluginDescriptor));
        try {
            File bundleDependencyFile = BundleUtils.getBundleDependencyFile(bundleDependency);
            Optional<String> schemaOptional = this.internalSchemaService.getSchema(bundleDependencyFile);
            if (schemaOptional.isPresent()) {
                return schemaOptional;
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot extract schema for artifact:{} ", (Object)pluginDescriptor, (Object)e);
        }
        return this.extensionModelServiceCache.loadExtensionInformation(bundleDependency, this.extensionModelService).map(loadedExtensionInformation -> (String)loadedExtensionInformation.getSchema().get());
    }

    @Override
    public List<ExtensionModel> getRuntimeExtensionModels() {
        return this.extensionModelServiceCache.loadRuntimeExtensionModels(this.extensionModelService);
    }
}

