/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.internal.application.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationCache
implements Disposable {
    private static final String TOOLING_CLIENT_APPLICATION_CACHE_EXPIRE_AFTER_ACCESS = "tooling.client.ApplicationCache.expireAfterAccess";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationCache.class);
    private Cache<String, Application> applicationsById = this.createCache();

    private Cache<String, Application> createCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        this.cacheExpireAfterAccess().ifPresent(value -> builder.expireAfterAccess(value.longValue(), TimeUnit.SECONDS));
        builder.removalListener(notification -> ((Application)notification.getValue()).dispose());
        return builder.build();
    }

    private Optional<Long> cacheExpireAfterAccess() {
        if (System.getProperty(TOOLING_CLIENT_APPLICATION_CACHE_EXPIRE_AFTER_ACCESS) == null) {
            return Optional.empty();
        }
        Long expireAfterAccess = Long.valueOf(System.getProperty(TOOLING_CLIENT_APPLICATION_CACHE_EXPIRE_AFTER_ACCESS));
        Preconditions.checkArgument((expireAfterAccess > 0L ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, cacheExpireAfterAccess cannot be less that zero", expireAfterAccess, TOOLING_CLIENT_APPLICATION_CACHE_EXPIRE_AFTER_ACCESS));
        return Optional.of(expireAfterAccess);
    }

    public ApplicationCache() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initialising Application cache");
        }
    }

    public Application getApplication(String id, Callable<Application> callable) {
        try {
            return (Application)this.applicationsById.get((Object)id, callable);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void invalidate(String id) {
        this.applicationsById.invalidate((Object)id);
    }

    public void dispose() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Disposing Application cache");
        }
        this.applicationsById.invalidateAll();
    }
}

