/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.mule.tooling.client.api.exception.ToolingException;

public final class IOUtils {
    public static byte[] readContentFromUrl(URL url, int connectTimeout, int readTimeout) {
        byte[] content;
        BufferedInputStream inputStream = null;
        Closeable outputStream = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
            urlConnection.setConnectTimeout(connectTimeout);
            urlConnection.setReadTimeout(readTimeout);
            inputStream = new BufferedInputStream(urlConnection.getInputStream());
            ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();
            org.apache.commons.io.IOUtils.copy((InputStream)inputStream, (OutputStream)bufferOutputStream);
            content = bufferOutputStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new ToolingException("Error while reading content from URL: " + url, (Throwable)e);
            }
            catch (Throwable throwable) {
                org.mule.runtime.core.api.util.IOUtils.closeQuietly(outputStream);
                org.mule.runtime.core.api.util.IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        org.mule.runtime.core.api.util.IOUtils.closeQuietly(outputStream);
        org.mule.runtime.core.api.util.IOUtils.closeQuietly((Closeable)inputStream);
        return content;
    }
}

