/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapReader;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapWriter;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;
import org.mule.tooling.client.internal.serialization.XStreamFactory;
import org.mule.tooling.client.internal.serialization.XmlArtifactDeserializationRequestConverter;

public final class XStreamServerSerializer {
    private static XStream createXStream() {
        XStream xStream = XStreamFactory.createXStream();
        xStream.registerConverter((Converter)new TypeAnnotationsMapConverter(XStreamClientSerializer.class.getClassLoader().getParent().getParent(), Collections.synchronizedList(new ArrayList()), xStream.getMapper()));
        xStream.registerConverter((Converter)new XmlArtifactDeserializationRequestConverter(xStream.getMapper()));
        xStream.ignoreUnknownElements();
        return xStream;
    }

    public static String serialize(Object object) {
        return XStreamServerSerializer.createXStream().toXML(object);
    }

    public static <T> T deserialize(String content) {
        return (T)XStreamServerSerializer.createXStream().fromXML(content);
    }

    private static class TypeAnnotationsMapConverter
    extends MapConverter {
        private TypeAnnotationMapWriter typeAnnotationMapWriter;
        private TypeAnnotationMapReader typeAnnotationMapReader;

        public TypeAnnotationsMapConverter(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient, Mapper mapper) {
            super(mapper);
            this.typeAnnotationMapWriter = new TypeAnnotationMapWriter(targetClassLoader, typeAnnotationsNotSupportedByToolingRuntimeClient);
            this.typeAnnotationMapReader = new TypeAnnotationMapReader();
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal((Object)this.typeAnnotationMapWriter.write((Map)source), writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map output = (Map)super.unmarshal(reader, context);
            return this.typeAnnotationMapReader.read(output);
        }
    }
}

